/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.animatable;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import oz.util.view.animatable.AnimatableFrameLayout;
import oz.util.view.animatable.AnimatableFrameLayout$OnMoveListener;
import oz.util.view.animatable.AnimatableScrollView$MinHeightRunnable;
import oz.util.view.animatable.AnimatableScrollView$MoveJob;
import oz.util.view.animatable.AnimatableScrollView$OnMoveListener;

public class AnimatableScrollView
extends ScrollView
implements AnimatableFrameLayout$OnMoveListener {
    private AnimatableFrameLayout mView;
    private AnimatableScrollView$OnMoveListener mListener;
    private AnimatableScrollView$MinHeightRunnable mMinHeightRunnable;
    private boolean mScrollToZeroInMove;
    private boolean mTouchDisableInMove;
    private boolean mAutoSetOldView;

    public AnimatableScrollView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mMinHeightRunnable = new AnimatableScrollView$MinHeightRunnable(this, null);
        this.mScrollToZeroInMove = true;
        this.mTouchDisableInMove = true;
        this.mAutoSetOldView = true;
        this.mView = new AnimatableFrameLayout(this.getContext());
        this.mView.setMoveListener(this);
        this.addView((View)this.mView, new ViewGroup.LayoutParams(-1, -2));
    }

    public AnimatableFrameLayout getContentView() {
        return this.mView;
    }

    private void autoSetOldView(View view) {
        if (this.mAutoSetOldView) {
            this.mView.setOldView(view);
        }
    }

    private void autoSetOldView_Add(View view) {
        if (this.mAutoSetOldView && view != null && this.mView.getChildCount() == 0) {
            this.autoSetOldView(view);
        }
    }

    public void addChildInContentView(View view) {
        this.addChildInContentView(view, 0);
    }

    public void addChildInContentView(View view, int n) {
        this.autoSetOldView_Add(view);
        this.mView.setContextVerticalAlign(n);
        int n2 = 16;
        if (n != 0) {
            n2 = 49;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, n2);
        this.mView.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void clearOldView() {
        this.mView.setOldView(null);
    }

    public void dispose() {
        this.clearOldView();
        this.removeAllViews();
        this.mView.removeAllViews();
        this.mView.setMoveListener(null);
    }

    public void setMoveListener(AnimatableScrollView$OnMoveListener animatableScrollView$OnMoveListener) {
        this.mListener = animatableScrollView$OnMoveListener;
    }

    public void doMoveNextView(View view, int n, boolean bl) {
        this.doMoveNextView(0L, view, n, bl);
    }

    public void doMoveNextView(long l, View view, int n, boolean bl) {
        AnimatableScrollView$MoveJob animatableScrollView$MoveJob = new AnimatableScrollView$MoveJob(this, null);
        animatableScrollView$MoveJob.nextView = view;
        animatableScrollView$MoveJob.duration = n;
        animatableScrollView$MoveJob.reverse = bl;
        this.postDelayed(animatableScrollView$MoveJob, l);
    }

    public void setTouchDisable(boolean bl) {
        this.mView.setTouchDisable(bl);
    }

    public boolean isTouchDisable() {
        return this.mView.isTouchDisable();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.isTouchDisable()) {
            return true;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isTouchDisable()) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mMinHeightRunnable.h = n2;
        this.post(this.mMinHeightRunnable);
    }

    public void OnStartMove(AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mTouchDisableInMove) {
            this.mView.setTouchDisable(true);
        }
        if (this.mListener != null) {
            this.mListener.OnStartMove(this, animatableFrameLayout, view, view2, bl);
        }
    }

    public void OnFinishMove(AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mListener != null) {
            this.mListener.OnFinishMove(this, animatableFrameLayout, view, view2, bl);
        }
    }

    public void OnAfterMove(AnimatableFrameLayout animatableFrameLayout, View view, View view2, boolean bl) {
        if (this.mTouchDisableInMove) {
            this.mView.setTouchDisable(false);
        }
        this.autoSetOldView(view);
        if (this.mListener != null) {
            this.mListener.OnAfterMove(this, animatableFrameLayout, view, view2, bl);
        }
    }

    static /* synthetic */ AnimatableFrameLayout access$000(AnimatableScrollView animatableScrollView) {
        return animatableScrollView.mView;
    }
}

