/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import oz.main.OZStorage;
import oz.util.view.camera.CameraBoxViewBase;
import oz.util.view.camera.CameraBoxViewBase$CameraBoxRender;

public class CameraBoxImageIDView
extends CameraBoxViewBase {
    private boolean mShowMaskArea;
    protected int gX1;
    protected int gY1;
    protected int gX2;
    protected int gY2;
    protected int gcolor = 0;
    protected int[] gmX;
    protected int[] gmY;
    protected int[] gmW;
    protected int[] gmH;

    public CameraBoxImageIDView(Context context) {
        super(context);
        this.mImageViewCameraMode = 2;
        this.mShowMaskArea = true;
    }

    public void setShowMaskArea(boolean bl) {
        this.mShowMaskArea = bl;
    }

    protected void updateDrawRectFlag() {
        this.mDrawWholeRect = false;
        this.mDrawOutRect = false;
        this.mDrawInRect = true;
        this.mDrawBackground = true;
    }

    public void setIDGuideInfo(int n, int n2, int n3, int n4, int n5) {
        this.gX1 = n;
        this.gY1 = n2;
        this.gX2 = n3;
        this.gY2 = n4;
        this.gcolor = n5;
    }

    public void setIDGuideMosaicInfo(int n, String string) {
        this.gmX = new int[n];
        this.gmY = new int[n];
        this.gmW = new int[n];
        this.gmH = new int[n];
        String[] stringArray = string.split(",");
        int n2 = 0;
        for (int j = 0; j < n; ++j) {
            this.gmX[j] = Integer.parseInt(stringArray[n2++]);
            this.gmY[j] = Integer.parseInt(stringArray[n2++]);
            this.gmW[j] = Integer.parseInt(stringArray[n2++]);
            this.gmH[j] = Integer.parseInt(stringArray[n2++]);
        }
    }

    protected void onDraw(Canvas canvas) {
        Path path;
        RectF rectF;
        boolean bl;
        super.onDraw(canvas);
        if (this.mBitmap != null) {
            canvas.save();
            if (this.mBitmapRotation != 0) {
                canvas.rotate((float)this.mBitmapRotation, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
            }
            canvas.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), this.mBitmapRect, this.mBitmapPaint);
            canvas.restore();
        }
        float f2 = 1.0f;
        boolean bl2 = bl = this.mImageViewCameraMode == 2;
        if (bl) {
            float f3 = this.mBitmapSize != null ? this.mBitmapSize.getWidth() : 1440.0f;
            f2 = this.getWholeRect().width() / f3;
        }
        if (this.mDrawBackground && !this.mWholeRect.isEmpty()) {
            canvas.save();
            this.mViewTempRect.setIntersect(this.mViewRect, this.mWholeRect);
            if (!this.mViewTempRect.isEmpty()) {
                Path path2 = new Path();
                path2.addRect(this.mViewTempRect, Path.Direction.CW);
                rectF = this.mInRect;
                if (bl) {
                    rectF = new RectF((float)this.gX1 * f2, (float)this.gY1 * f2, (float)this.gX2 * f2, (float)this.gY2 * f2);
                    rectF.offset(this.getWholeRect().left, this.getWholeRect().top);
                }
                this.mViewTempRect.setIntersect(this.mViewRect, rectF);
                if (!this.mViewTempRect.isEmpty()) {
                    path = new Path();
                    path.addRect(this.mViewTempRect, Path.Direction.CW);
                    path2.op(path2, path, Path.Op.DIFFERENCE);
                }
                canvas.clipPath(path2);
            }
            canvas.drawColor(this.mBackgroundColor);
            canvas.restore();
        }
        if (this.mDrawWholeRect) {
            this.drawRect(canvas, this.mWholeRect, this.mWholeRectPaint);
        }
        if (this.mDrawOutRect) {
            this.drawRect(canvas, this.mOutRect, this.mOutRectPaint);
        }
        if (this.mDrawInRect && this.gX1 != 0 && this.gY1 != 0 && this.gX2 != 0 && this.gY2 != 0) {
            if (bl) {
                Paint paint = new Paint(1);
                paint.setColor(-1);
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(1.5f * OZStorage.m_scaledDensity);
                rectF = new Paint(1);
                rectF.setColor(Color.rgb((int)66, (int)133, (int)244));
                rectF.setStyle(Paint.Style.STROKE);
                rectF.setStrokeWidth(1.5f * OZStorage.m_scaledDensity);
                path = new Paint(1);
                path.setColor(0x3300FF00);
                path.setStyle(Paint.Style.FILL);
                path.setStrokeWidth(1.5f * OZStorage.m_scaledDensity);
                if (this.gX1 > 0) {
                    if (this.gcolor == 3) {
                        paint.setColor(Color.rgb((int)254, (int)100, (int)46));
                    } else if (this.gcolor == 2) {
                        paint.setColor(Color.rgb((int)255, (int)178, (int)150));
                    } else {
                        paint.setColor(-1);
                    }
                }
                canvas.save();
                canvas.translate(this.getWholeRect().left, this.getWholeRect().top);
                canvas.scale(f2, f2);
                canvas.drawRect((float)this.gX1, (float)this.gY1, (float)this.gX2, (float)this.gY2, paint);
                if (this.mShowMaskArea && this.gmX != null && this.gmX.length > 0) {
                    for (int j = 0; j < this.gmX.length; ++j) {
                        canvas.drawRect((float)(this.gmX[j] + this.gX1), (float)(this.gmY[j] + this.gY1), (float)(this.gmX[j] + this.gmW[j] + this.gX1), (float)(this.gmY[j] + this.gmH[j] + this.gY1), (Paint)path);
                        canvas.drawRect((float)(this.gmX[j] + this.gX1), (float)(this.gmY[j] + this.gY1), (float)(this.gmX[j] + this.gmW[j] + this.gX1), (float)(this.gmY[j] + this.gmH[j] + this.gY1), (Paint)rectF);
                    }
                }
                canvas.restore();
            } else {
                this.drawRect(canvas, this.mInRect, this.mInRectPaint);
            }
        }
        if (this.mBoxDraw && this.mBox != null && this.mBox.length > 0) {
            if (this.mBoxRender == null) {
                this.mBoxRender = new CameraBoxViewBase$CameraBoxRender();
            }
            this.mBoxRender.render(canvas, this.mBox);
        }
    }
}

