/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import oz.util.view.camera.CameraBoxViewBase;
import oz.util.view.camera.CameraBoxViewBase$CameraBoxRender;

public class CameraBoxImagePickerView
extends CameraBoxViewBase {
    public CameraBoxImagePickerView(Context context) {
        super(context);
        this.mImageViewCameraMode = 0;
    }

    protected void updateDrawRectFlag() {
        this.mDrawWholeRect = false;
        this.mDrawOutRect = false;
        this.mDrawInRect = true;
        this.mDrawBackground = true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBitmap != null) {
            canvas.save();
            if (this.mBitmapRotation != 0) {
                canvas.rotate((float)this.mBitmapRotation, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
            }
            canvas.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), this.mBitmapRect, this.mBitmapPaint);
            canvas.restore();
        }
        if (this.mDrawBackground && !this.mWholeRect.isEmpty()) {
            canvas.save();
            this.mViewTempRect.setIntersect(this.mViewRect, this.mWholeRect);
            if (!this.mViewTempRect.isEmpty()) {
                Path path = new Path();
                path.addRect(this.mViewTempRect, Path.Direction.CW);
                RectF rectF = this.mInRect;
                this.mViewTempRect.setIntersect(this.mViewRect, rectF);
                if (!this.mViewTempRect.isEmpty()) {
                    Path path2 = new Path();
                    path2.addRect(this.mViewTempRect, Path.Direction.CW);
                    path.op(path, path2, Path.Op.DIFFERENCE);
                }
                canvas.clipPath(path);
            }
            canvas.drawColor(this.mBackgroundColor);
            canvas.restore();
        }
        if (this.mDrawWholeRect) {
            this.drawRect(canvas, this.mWholeRect, this.mWholeRectPaint);
        }
        if (this.mDrawOutRect) {
            this.drawRect(canvas, this.mOutRect, this.mOutRectPaint);
        }
        if (this.mDrawInRect) {
            this.drawRect(canvas, this.mInRect, this.mInRectPaint);
        }
        if (this.mBoxDraw && this.mBox != null && this.mBox.length > 0) {
            if (this.mBoxRender == null) {
                this.mBoxRender = new CameraBoxViewBase$CameraBoxRender();
            }
            this.mBoxRender.render(canvas, this.mBox);
        }
    }
}

