/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.Image;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.resource.OZAndroidResource;
import oz.util.OZButton;
import oz.util.view.camera.Camera2Manager;
import oz.util.view.camera.Camera2Manager$OnCamera2ManagerListener;
import oz.util.view.camera.Camera2PreviewView;
import oz.util.view.camera.CameraBoxImageIDView;
import oz.util.view.camera.CameraBoxImagePickerView;
import oz.util.view.camera.CameraBoxImageSealView;
import oz.util.view.camera.CameraBoxViewBase;
import oz.util.view.camera.CameraUtil;
import oz.util.view.camera.CameraView$1;
import oz.util.view.camera.CameraView$2;
import oz.util.view.camera.CameraView$CameraViewHandler;
import oz.util.view.camera.CameraView$OnCameraViewListener;
import oz.util.view.camera.CameraViewButtonEvent;
import oz.util.view.camera.TakePictureListener;
import oz.util.view.camera.TakePreviewListener;
import oz.viewer.ui.df.DFUtils;

public class CameraView
extends FrameLayout
implements View.OnClickListener,
Camera2Manager$OnCamera2ManagerListener {
    private static final int ID_CONTENT_LAYOUT = 0xFFF0001;
    private static final int ID_CAMERA_LAYOUT = 0xFFF0002;
    private static final int ID_CAMERA_VIEW = 0xFFF0003;
    private static final int ID_CONTENT_TOP_LAYOUT = 0xFFF0004;
    private static final int ID_CONTENT_MID_LAYOUT = 0xFFF0005;
    private static final int ID_CONTENT_BOTTOM_LAYOUT = 0xFFF0006;
    private static final int ID_CONTENT_BTN_SHOT = 0xFFF1000;
    private static final int ID_CONTENT_BTN_EXIT = 0xFFF1001;
    private static final int ID_CONTENT_BTN_FLASH = 268374018;
    private static final int ID_CONTENT_BTN_FACING = 268374019;
    private static final int IMAGEPICKER_CAMERA_FLASHMODE_OFF = 0;
    private static final int IMAGEPICKER_CAMERA_FLASHMODE_ON = 1;
    private static final int IMAGEPICKER_CAMERA_FLASHMODE_AUTO = 2;
    private boolean mUsePreviewListener;
    private float mTargetRatio;
    private Camera2PreviewView mCameraSurfaceView;
    private Camera2Manager mCameraManager;
    private CameraBoxViewBase mCameraBoxView;
    private CameraViewButtonEvent mCameraViewButtonEvent;
    private TakePictureListener mPictureListener;
    private TakePreviewListener mPreviewListener;
    private int mCurrentRotation;
    private int mCurrentRotation2;
    private int mCurrentOrientation;
    private OrientationEventListener mOrientationListener;
    private CameraView$CameraViewHandler mHandler;
    private boolean mIsCameraShowToolbar;
    private boolean mIsCameraToolbarFlash;
    private boolean mIsCameraToolbarFacing;
    private int mFlashMode;
    private int mFacingMode;
    private int[] flashArray = new int[]{0, 1, 2};
    private int idCount;
    private CameraView$OnCameraViewListener mCameraViewListener;
    private int mImageViewCameraMode;
    private boolean mShowMaskArea;
    private byte[] mTakePictureBytes;

    public CameraView(Context context, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, boolean bl4) {
        super(context);
        this.mImageViewCameraMode = n;
        this.mIsCameraShowToolbar = bl;
        this.mIsCameraToolbarFlash = bl2;
        this.mIsCameraToolbarFacing = bl3;
        this.mFlashMode = n2;
        this.mFacingMode = n3;
        this.mHandler = new CameraView$CameraViewHandler(this, null);
        this.mCurrentRotation = context.getResources().getConfiguration().orientation;
        this.mCurrentRotation2 = -1;
        this.mShowMaskArea = bl4;
        this.mOrientationListener = new CameraView$1(this, this.getContext(), 2);
        this.init();
    }

    public void setCameraViewListener(CameraView$OnCameraViewListener cameraView$OnCameraViewListener) {
        this.mCameraViewListener = cameraView$OnCameraViewListener;
    }

    public void enableOrientationDetect() {
        this.mOrientationListener.enable();
    }

    public void disableOrientationDetect() {
        this.mOrientationListener.disable();
    }

    public void init() {
        this.setTargetRatio(-1.0f);
        this.setUsePreviewListener(false);
        this.initLayout();
    }

    public void setCurrentRotation(int n, int n2) {
        if (n != this.mCurrentRotation || n2 != this.mCurrentRotation2) {
            this.mCurrentRotation = n;
            this.mCurrentRotation2 = n2;
            this.updateRotation();
        }
    }

    public void updateToobarButton() {
        OZButton oZButton = (OZButton)this.findViewById(268374018);
        OZButton oZButton2 = (OZButton)this.findViewById(268374019);
        Drawable drawable2 = DFUtils.getImageDrawable(this.getContext(), 32);
        Drawable drawable3 = DFUtils.getImageDrawable(this.getContext(), 32);
        if (this.mCameraManager.isAbleFlash()) {
            if (this.mFlashMode == 0) {
                drawable2 = DFUtils.getImageDrawable(this.getContext(), 32);
            } else if (this.mFlashMode == 1) {
                drawable2 = DFUtils.getImageDrawable(this.getContext(), 34);
            } else if (this.mFlashMode == 2) {
                drawable2 = DFUtils.getImageDrawable(this.getContext(), 30);
            }
            oZButton.setEnabled(true);
        } else if (this.mFlashMode == 0) {
            drawable2 = DFUtils.getImageDrawable(this.getContext(), 33);
        } else if (this.mFlashMode == 1) {
            drawable2 = DFUtils.getImageDrawable(this.getContext(), 35);
        } else if (this.mFlashMode == 2) {
            drawable2 = DFUtils.getImageDrawable(this.getContext(), 31);
        }
        drawable3 = DFUtils.getImageDrawable(this.getContext(), 36);
        if (this.mIsCameraShowToolbar) {
            if (!this.mIsCameraToolbarFlash) {
                oZButton.setVisibility(8);
            }
            if (!this.mIsCameraToolbarFacing) {
                oZButton2.setVisibility(8);
            }
        } else {
            oZButton.setVisibility(8);
            oZButton2.setVisibility(8);
        }
        oZButton.setBackground(drawable2);
        oZButton2.setBackground(drawable3);
    }

    public void updateRotation() {
        if (this.mCameraManager != null) {
            LinearLayout linearLayout = (LinearLayout)this.findViewById(0xFFF0001);
            FrameLayout frameLayout = (FrameLayout)this.findViewById(0xFFF0004);
            FrameLayout frameLayout2 = (FrameLayout)this.findViewById(0xFFF0005);
            FrameLayout frameLayout3 = (FrameLayout)this.findViewById(0xFFF0006);
            int n = 0;
            LinearLayout.LayoutParams layoutParams = null;
            LinearLayout.LayoutParams layoutParams2 = null;
            LinearLayout.LayoutParams layoutParams3 = null;
            switch (this.mCurrentRotation) {
                case 1: {
                    n = 1;
                    layoutParams = new LinearLayout.LayoutParams(-1, -2);
                    layoutParams2 = new LinearLayout.LayoutParams(-1, 1, 1.0f);
                    layoutParams3 = new LinearLayout.LayoutParams(-1, -2);
                    break;
                }
                default: {
                    n = 0;
                    layoutParams = new LinearLayout.LayoutParams(-2, -1);
                    layoutParams2 = new LinearLayout.LayoutParams(1, -1, 1.0f);
                    layoutParams3 = new LinearLayout.LayoutParams(-2, -1);
                }
            }
            linearLayout.setOrientation(n);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            frameLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            frameLayout3.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
            if (this.mCameraManager.isRunningCamera()) {
                this.mHandler.removeMessages(2);
                this.mHandler.removeMessages(3);
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(4);
                this.mHandler.sendEmptyMessage(2);
                this.mHandler.sendEmptyMessage(1);
                this.mHandler.sendEmptyMessageDelayed(3, 500L);
                this.mHandler.sendEmptyMessageDelayed(4, 600L);
            }
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        CameraUtil.d("call orientation changed from onConfigurationChanged");
        this.setCurrentRotation(configuration.orientation, -1);
    }

    public void initLayout() {
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setId(0xFFF0002);
        frameLayout.setBackgroundColor(-16777216);
        this.addView((View)frameLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mCameraSurfaceView = new Camera2PreviewView(this.getContext());
        this.mCameraSurfaceView.setId(0xFFF0003);
        this.mCameraSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        frameLayout.addView((View)this.mCameraSurfaceView);
        if (this.mImageViewCameraMode == 0) {
            this.mCameraBoxView = new CameraBoxImagePickerView(this.getContext());
        } else if (this.mImageViewCameraMode == 1) {
            this.mCameraBoxView = new CameraBoxImageSealView(this.getContext());
        } else if (this.mImageViewCameraMode == 2) {
            this.mCameraBoxView = new CameraBoxImageIDView(this.getContext());
            ((CameraBoxImageIDView)this.mCameraBoxView).setShowMaskArea(this.mShowMaskArea);
        }
        frameLayout.addView((View)this.mCameraBoxView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mCameraManager = new Camera2Manager(this);
        if (this.mCameraManager != null) {
            this.mCameraManager.setCameraID(this.mFacingMode);
            this.mCameraManager.setFlashMode(this.mFlashMode);
            this.mCameraManager.setCamera2ManagerListener(this);
        }
        if (CameraUtil.checkCameraHardware(this.getContext()) && CameraUtil.hasAllPermissionsGranted(this.getContext())) {
            this.mCameraManager.onResume();
        } else {
            CameraUtil.d("check permission or hardware");
        }
        this.idCount = this.mCameraManager.getIDCount();
        this.mCameraBoxView.setOnTouchListener(new CameraView$2(this));
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setId(0xFFF0001);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(new FrameLayout.LayoutParams(-1, -1)));
        FrameLayout frameLayout2 = new FrameLayout(this.getContext());
        frameLayout2.setId(0xFFF0004);
        linearLayout.addView((View)frameLayout2);
        FrameLayout frameLayout3 = new FrameLayout(this.getContext());
        frameLayout3.setId(0xFFF0005);
        linearLayout.addView((View)frameLayout3);
        FrameLayout frameLayout4 = new FrameLayout(this.getContext());
        frameLayout4.setId(0xFFF0006);
        linearLayout.addView((View)frameLayout4);
        Button button = new Button(this.getContext());
        button.setId(0xFFF1000);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842919}, DFUtils.getImageDrawable(this.getContext(), 28));
        stateListDrawable.addState(new int[]{16842919}, DFUtils.getImageDrawable(this.getContext(), 29));
        button.setBackground((Drawable)stateListDrawable);
        button.setOnClickListener((View.OnClickListener)this);
        int n = DFUtils.toDP(this.getContext(), 60.0f);
        int n2 = DFUtils.toDP(this.getContext(), 10.0f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n, n, 17);
        layoutParams.setMargins(n2, n2, n2, n2);
        frameLayout4.addView((View)button, (ViewGroup.LayoutParams)layoutParams);
        OZButton oZButton = new OZButton(this.getContext());
        oZButton.setId(268374018);
        oZButton.setOnClickListener(this);
        OZButton oZButton2 = new OZButton(this.getContext());
        oZButton2.setId(268374019);
        oZButton2.setOnClickListener(this);
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(n, n, 85);
        FrameLayout.LayoutParams layoutParams3 = new FrameLayout.LayoutParams(n, n, 85);
        layoutParams2.setMargins(n2, n2, n2, n2);
        layoutParams3.setMargins(n2, n2, n + n2 * 2, n2);
        frameLayout4.addView((View)oZButton, (ViewGroup.LayoutParams)layoutParams2);
        frameLayout4.addView((View)oZButton2, (ViewGroup.LayoutParams)layoutParams3);
        Button button2 = new Button(this.getContext());
        button2.setId(0xFFF1001);
        button2.setBackground(DFUtils.getImageDrawable(this.getContext(), 9));
        button2.setOnClickListener((View.OnClickListener)this);
        int n3 = DFUtils.toDP(this.getContext(), 40.0f);
        int n4 = DFUtils.toDP(this.getContext(), 10.0f);
        FrameLayout.LayoutParams layoutParams4 = new FrameLayout.LayoutParams(n3, n3, 3);
        layoutParams4.setMargins(n4, n4, n4, n4);
        frameLayout2.addView((View)button2, (ViewGroup.LayoutParams)layoutParams4);
        if (this.mImageViewCameraMode != 0 && (this.mImageViewCameraMode == 1 || this.mImageViewCameraMode == 2)) {
            int n5 = DFUtils.toDP(this.getContext(), 20.0f);
            TextView textView = new TextView(this.getContext());
            textView.setTextSize(24.0f);
            textView.setTextColor(-1);
            if (this.mImageViewCameraMode == 1) {
                textView.setText((CharSequence)OZAndroidResource.getResource("image.seal"));
            } else if (this.mImageViewCameraMode == 2) {
                textView.setText((CharSequence)OZAndroidResource.getResource("image.idcard"));
            }
            textView.setBackgroundColor(Color.argb((int)100, (int)0, (int)0, (int)0));
            textView.setGravity(17);
            textView.setPadding(n5, n5, n5, n5);
            FrameLayout.LayoutParams layoutParams5 = new FrameLayout.LayoutParams(-1, -2, 48);
            frameLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams5);
        }
        this.updateRotation();
        this.updateToobarButton();
    }

    public void setPictureListener(TakePictureListener takePictureListener) {
        this.mPictureListener = takePictureListener;
    }

    public void setPreviewListener(TakePreviewListener takePreviewListener) {
        this.mPreviewListener = takePreviewListener;
    }

    public void setButtonEventListener(CameraViewButtonEvent cameraViewButtonEvent) {
        this.mCameraViewButtonEvent = cameraViewButtonEvent;
    }

    public Camera2Manager getCameraManager() {
        return this.mCameraManager;
    }

    public CameraBoxViewBase getBoxView() {
        return this.mCameraBoxView;
    }

    public Camera2PreviewView getCameraPreviewView() {
        return this.mCameraSurfaceView;
    }

    public void setTargetRatio(float f2) {
        this.mTargetRatio = f2 > 0.0f ? f2 : -1.0f;
    }

    public float getTargetRatio() {
        return this.mTargetRatio;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.updateCameraLayout();
    }

    public void updateCameraLayout() {
    }

    public void setUsePreviewListener(boolean bl) {
        this.mUsePreviewListener = bl;
    }

    public boolean isUsePreviewListener() {
        return this.mUsePreviewListener;
    }

    boolean needNextCameraFrame() {
        if (this.mPreviewListener != null) {
            return this.mPreviewListener.acceptPreview();
        }
        return false;
    }

    boolean needTakePicture() {
        if (this.mPictureListener != null) {
            return this.mPictureListener.acceptPicture();
        }
        return false;
    }

    public void setShotButtonVisible(boolean bl) {
        Button button = (Button)this.findViewById(0xFFF1000);
        if (button != null) {
            button.setVisibility(bl ? 0 : 4);
        }
    }

    void OnCameraPreview(Image image, int n) {
        if (this.mPreviewListener != null) {
            this.mPreviewListener.onTakePreview(image, n);
        }
    }

    void OnTakePicture(Image image, int n) {
        if (this.mPictureListener != null) {
            this.mPictureListener.onSuccessTakePicture(image, n);
        }
    }

    void onTakePictureFailed(String string) {
        if (this.mPictureListener != null) {
            this.mPictureListener.onFailedTakePicture(string);
        }
    }

    public void dispose() {
        if (this.mCameraManager.isRunningCamera()) {
            this.mCameraManager.onPause();
        }
        this.mCameraBoxView.setDrawInRect(false);
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 0xFFF1000: {
                if (this.mCameraViewButtonEvent == null) break;
                this.mCameraViewButtonEvent.onClickShot(this);
                break;
            }
            case 0xFFF1001: {
                if (this.mCameraViewButtonEvent == null) break;
                this.mCameraViewButtonEvent.onClickExit(this);
                break;
            }
            case 268374018: {
                ++this.mFlashMode;
                this.mFlashMode = this.mFlashMode >= this.flashArray.length ? this.flashArray[0] : this.mFlashMode;
                this.mCameraManager.setFlashMode(this.mFlashMode);
                this.mCameraManager.swtichFlash();
                this.mCameraViewListener.setFlashMode(this.mFlashMode);
                this.updateToobarButton();
                break;
            }
            case 268374019: {
                if (this.mCameraManager == null || this.idCount <= 1) break;
                this.mFacingMode = this.mCameraManager.switchCamera();
                this.mCameraViewListener.setFacingMode(this.mFacingMode);
                this.updateToobarButton();
            }
        }
    }

    public void callUpdateRotation() {
        int n = 45 < this.mCurrentOrientation && this.mCurrentOrientation < 135 || 225 < this.mCurrentOrientation && this.mCurrentOrientation < 315 ? 2 : 1;
        this.setCurrentRotation(n, -1);
    }

    static /* synthetic */ Camera2Manager access$000(CameraView cameraView) {
        return cameraView.mCameraManager;
    }

    static /* synthetic */ CameraBoxViewBase access$100(CameraView cameraView) {
        return cameraView.mCameraBoxView;
    }

    static /* synthetic */ Camera2PreviewView access$200(CameraView cameraView) {
        return cameraView.mCameraSurfaceView;
    }

    static /* synthetic */ int access$400(CameraView cameraView) {
        return cameraView.mCurrentRotation2;
    }

    static /* synthetic */ int access$402(CameraView cameraView, int n) {
        cameraView.mCurrentRotation2 = n;
        return cameraView.mCurrentRotation2;
    }

    static /* synthetic */ int access$502(CameraView cameraView, int n) {
        cameraView.mCurrentOrientation = n;
        return cameraView.mCurrentOrientation;
    }
}

