/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import java.text.SimpleDateFormat;
import java.util.Date;
import oz.util.speech.OZSpeechManager;
import oz.util.speech.OZSpeechRequestInfo;
import oz.util.view.animatable.AnimatableScrollView;
import oz.viewer.ui.df.DFHandler;
import oz.viewer.ui.df.DFInfoConnector;
import oz.viewer.ui.df.DFManager$1;
import oz.viewer.ui.df.DFManager$2;
import oz.viewer.ui.df.DFManager$3;
import oz.viewer.ui.df.DFManager$4;
import oz.viewer.ui.df.DFManager$5;
import oz.viewer.ui.df.DFManager$DFManagerListener;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.ctrl.DFCompCtrl;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl$FromSTTInfo;
import oz.viewer.ui.df.ctrl.DFSpeechCtrl;
import oz.viewer.ui.df.view.BubbleTextLayout;
import oz.viewer.ui.df.view.BubbleTextLayout$BubbleInfo;
import oz.viewer.ui.df.view.DFInflaterView;
import oz.viewer.ui.df.view.DFLayoutHelper;
import oz.viewer.ui.df.view.DFMicBtnView$MIC_STATE;
import oz.viewer.ui.df.view.DFProgressbar;

public class DFManager {
    public static final int ID_IMAGE_BG = 0;
    public static final int ID_IMAGE_SPEAKER_ON = 1;
    public static final int ID_IMAGE_SPEAKER_OFF = 2;
    public static final int ID_IMAGE_UP_NORMAL = 5;
    public static final int ID_IMAGE_DOWN_NORMAL = 7;
    public static final int ID_IMAGE_CLOSE_NORMAL = 9;
    public static final int ID_IMAGE_VOICERECORDER_READY = 12;
    public static final int ID_IMAGE_VOICERECORDER_STOP = 13;
    public static final int ID_IMAGE_VOICERECORDER_PLAY = 14;
    public static final int ID_IMAGE_VOICERECORDER_PAUSE = 15;
    public static final int ID_IMAGE_VOICERECORDER_CLEAR = 17;
    public static final int ID_IMAGE_ATTACHMENT_IMAGE = 20;
    public static final int ID_IMAGE_XBUTTON = 23;
    public static final int ID_IMAGE_SIGNATURE = 26;
    public static final int ID_IMAGE_CAMERA = 27;
    public static final int ID_IMAGE_TAKEPICTURE_NORMAL = 28;
    public static final int ID_IMAGE_TAKEPICTURE_PRESSED = 29;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_AUTO = 30;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_AUTO_D = 31;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_OFF = 32;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_OFF_D = 33;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_ON = 34;
    public static final int ID_IMAGE_TAKEPICTURE_FLASH_ON_D = 35;
    public static final int ID_IMAGE_TAKEPICTURE_FACING_SWITCH = 36;
    public static final int ID_IMAGE_SEAL = 38;
    public static final int ID_IMAGE_IDCARD = 39;
    public static final int ID_IMAGE_POPUP_ARROR = 40;
    public static final int ID_IMAGE_POPUP_CALENDAR = 41;
    public static final int ID_IMAGE_ATTACHMENT_MERGE = 42;
    public static final int ID_IMAGE_ATTACHMENT_GRABBER = 43;
    public static final String[] imageStore = new String[]{"DFBG.png", "speakon.png", "speakoff.png", "voiceon.png", "voiceoff.png", "up.png", "up.png", "down.png", "down.png", "close.png", "close.png", "next_arrow.png", "vr_ready.png", "vr_stop.png", "vr_play.png", "vr_pause.png", "vr_mic.png", "vr_clear.png", "at_document.png", "at_camera.png", "at_image.png", "nm_minus.png", "nm_plus.png", "xbutton.png", "left.png", "right.png", "signature.png", "camera.png", "takepicture_normal.png", "takepicture_pressed.png", "ip_flash_auto.png", "ip_flash_auto_d.png", "ip_flash_off.png", "ip_flash_off_d.png", "ip_flash_on.png", "ip_flash_on_d.png", "ip_facing_switch.png", "ip_facing_switch_d.png", "seal.png", "idcard.png", "popup_dropdown.png", "popup_calendar.png", "at_merge.png", "attachment_icon_hamburger.png"};
    public static final int ID_ROOT_BACKGROUND_DUMMY = 104857;
    public static final int ID_ROOT_DUMMY = 104856;
    public static final int ID_ROOT = 65536;
    public static final int ID_TOP = 4096;
    public static final int ID_TOP_BAR = 4352;
    public static final int ID_TOP_BAR_BTN_DISMISS = 4353;
    public static final int ID_TOP_BAR_TV_COMP_TITLE = 4354;
    public static final int ID_TOP_BAR_TV_DISPLAYNAME = 4355;
    public static final int ID_TOP_GROUP = 4356;
    public static final int ID_TOP_GROUP_FIXEDLINE = 4359;
    public static final int ID_TOP_CONTENT_SCROLL = 4608;
    public static final int ID_TOP_CONTENT = 4864;
    public static final int ID_TOP_CONTENT_TV_COMP_LAYOUT = 4882;
    public static final int ID_TOP_CONTENT_BTN_STT_MIC = 5121;
    public static final int ID_TOP_CONTENT_BTN_STT_MIC_BUBBLE = 5122;
    public static final int ID_BOTTOM = 8192;
    public static final int ID_BOTTOM_BAR_BTN_TTS_ALLOW = 8448;
    public static final int ID_BOTTOM_BAR_BTN_STT_ALLOW = 8449;
    public static final int ID_BOTTOM_BAR_BTN_AUTO_PROGRESS = 8450;
    public static final int ID_BOTTOM_BAR_PROGRESS = 8451;
    public static final int ID_BOTTOM_BAR_BTN_PREV = 8452;
    public static final int ID_BOTTOM_BAR_BTN_NEXT = 8453;
    public static final int ID_POPUPVIEW = 12288;
    public static final int ID_RESET_BUTTON = 12289;
    public static final int MOVE_FROM_CLICK = 0;
    public static final int MOVE_FROM_CONFIRM = 1;
    public static final int MOVE_FROM_SIMPLE_MOVE = 2;
    public static final int MOVE_FROM_SCROLL = 4;
    public static final int MOVE_FROM_JUST_OPEN = 5;
    private static final int CONST_TTS_DELAY = 1000;
    private DFInfoConnector mConnector;
    private DFCompCtrl mCompCtrl;
    private DFEFormBotCtrl mEFormBotCtrl;
    private DFSpeechCtrl mSpeechCtrl;
    private DFHandler mHandler;
    private Context mContext;
    private Dialog mDialog;
    private boolean mUseAuto;
    private boolean mUseAutoNow;
    private int mDialogWidth;
    private int mDialogHeight;
    private DFManager$DFManagerListener mListener;
    private VelocityTracker mVelocityTracker;
    private boolean mEnablePrev;
    private boolean mEnableNext;
    private boolean mUseLayoutChange;

    public void onTouch(View view, MotionEvent motionEvent) {
        this.mListener.onTouch(view, motionEvent);
    }

    public DFManager(Context context, DFInfoConnector dFInfoConnector) {
        this.mContext = context;
        this.mConnector = dFInfoConnector;
        this.mHandler = new DFHandler(this);
        this.mUseAuto = true;
        this.mUseAutoNow = this.mConnector.getAutoNext();
        this.mUseLayoutChange = true;
        this.mCompCtrl = new DFCompCtrl(this);
        this.mEFormBotCtrl = new DFEFormBotCtrl(this.mConnector.getEformServiceURL(), this.mConnector.getEformAuthorizedKey());
        this.mSpeechCtrl = new DFSpeechCtrl(this);
        this.mListener = new DFManager$DFManagerListener(this);
        this.mEFormBotCtrl.setOnResultListener(this.mListener);
        OZSpeechManager.getInstance(((Activity)context).getBaseContext()).setDFLocaleListener(this.mListener);
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getDialogWidth() {
        return this.mDialogWidth;
    }

    public int getDialogHeight() {
        return this.mDialogHeight;
    }

    public boolean isUseAutoProgress() {
        return this.mUseAuto;
    }

    public boolean isUseAutoProgressNow() {
        return this.mUseAutoNow;
    }

    public DFInfoConnector getConnector() {
        return this.mConnector;
    }

    public DFCompCtrl getCompCtrl() {
        return this.mCompCtrl;
    }

    public DFEFormBotCtrl getEFormBotCtrl() {
        return this.mEFormBotCtrl;
    }

    public DFSpeechCtrl getSpeechCtrl() {
        return this.mSpeechCtrl;
    }

    public DFHandler getDFHandler() {
        return this.mHandler;
    }

    public void cancelSpeechAndBubble() {
        this.cancelSpeech();
        this.bubbleClear(false);
    }

    public void cancelSpeech() {
        this.mEFormBotCtrl.cancelAll();
        if (this.mSpeechCtrl == null) {
            return;
        }
        this.mSpeechCtrl.getMicBtnManager().setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
        this.mSpeechCtrl.cancelAll();
    }

    private BubbleTextLayout getBubbleLayout() {
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            return (BubbleTextLayout)dialog.findViewById(5122);
        }
        return null;
    }

    public void bubbleUpdate(String string, boolean bl, int n, boolean bl2) {
        BubbleTextLayout bubbleTextLayout = this.getBubbleLayout();
        if (bubbleTextLayout != null) {
            boolean bl3;
            BubbleTextLayout$BubbleInfo bubbleTextLayout$BubbleInfo = new BubbleTextLayout$BubbleInfo();
            bubbleTextLayout$BubbleInfo.id = n;
            bubbleTextLayout$BubbleInfo.content = string;
            boolean bl4 = bl3 = bl2 || n != bubbleTextLayout.getFirstItemID();
            if (bl3) {
                if (bubbleTextLayout.size() == 2) {
                    bubbleTextLayout.removeLast(true);
                }
                bubbleTextLayout.insert(bubbleTextLayout$BubbleInfo, bl);
            } else {
                bubbleTextLayout.update(bubbleTextLayout$BubbleInfo);
            }
        }
    }

    public void bubbleClear(boolean bl) {
        BubbleTextLayout bubbleTextLayout = this.getBubbleLayout();
        if (bubbleTextLayout != null) {
            bubbleTextLayout.clear(bl);
        }
    }

    public void cancelSpeech(OZSpeechRequestInfo oZSpeechRequestInfo) {
        this.mEFormBotCtrl.cancelAll();
        if (this.mSpeechCtrl == null) {
            return;
        }
        if (oZSpeechRequestInfo.mode == 1 || oZSpeechRequestInfo.mode == 3) {
            this.mSpeechCtrl.getMicBtnManager().setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
        }
        this.mSpeechCtrl.cancelAll();
    }

    public void dismissDialog() {
        AnimatableScrollView animatableScrollView;
        Dialog dialog = this.mDialog;
        if (dialog != null) {
            animatableScrollView = (AnimatableScrollView)this.mDialog.findViewById(4608);
            if (animatableScrollView != null) {
                animatableScrollView.dispose();
            }
            this.mDialog.setContentView(new View(this.getContext()));
        }
        this.mDialog = null;
        if (dialog != null && dialog.isShowing()) {
            this.mCompCtrl.saveValue();
            this.mCompCtrl.callKillFocusEvent();
            this.mCompCtrl.clearComp();
            this.cancelSpeechAndBubble();
            dialog.dismiss();
            this.resetEnv();
        }
        if (dialog != null) {
            animatableScrollView = (AnimatableScrollView)this.mDialog.findViewById(4608);
            if (animatableScrollView != null) {
                animatableScrollView.dispose();
            }
            this.mDialog.setContentView(new View(this.getContext()));
        }
        this.mDialog = null;
    }

    public void callDismissDialog() {
        Object object;
        boolean bl;
        Boolean bl2;
        DFInflaterView dFInflaterView;
        if (!this.mConnector.getIsNotDFList() && (dFInflaterView = this.getCompCtrl().getCurrentView()) != null && dFInflaterView.getCurrentCompView() != null && (bl2 = (Boolean)dFInflaterView.getCurrentCompView().script(-16777206, null)).booleanValue() && (bl = dFInflaterView.onValueChanged((object = dFInflaterView.getCurrentCompView().script(-16777211, null)) == null ? "" : object.toString()))) {
            this.getConnector().setMessageHandlerWaitFlag(false);
            this.getConnector().callNextMessage();
            return;
        }
        this.mConnector.callDismissDialog();
    }

    private void resetEnv() {
        this.mConnector.clearList();
    }

    private boolean calcDialogSize() {
        boolean bl = DFUtils.isMobile(this.getContext());
        Point point = DFUtils.getScreenSize((Activity)this.mContext);
        int n = point.x;
        int n2 = point.y;
        boolean bl2 = bl || this.mConnector.getDisplayArea() == 0;
        int n3 = bl2 ? point.x : (int)((float)point.x * 0.9f);
        int n4 = bl2 ? point.y : (int)((float)point.y * 0.9f);
        boolean bl3 = false;
        if (!bl && this.mConnector.getContentSize() > 0) {
            int n5 = DFUtils.toPx(this.getContext(), this.mConnector.getContentSize());
            if (this.mConnector.getDisplayArea() == 0) {
                n3 = n;
                n4 = n2;
                if (n5 > 0 && n > n5) {
                    // empty if block
                }
            } else {
                n3 = n5 > n ? n : n5;
            }
        }
        if (this.mDialogWidth != n3 || this.mDialogHeight != n4) {
            this.mDialogWidth = n3;
            this.mDialogHeight = n4;
            bl3 = true;
        }
        return bl3;
    }

    public void setViewDisable(boolean bl) {
        AnimatableScrollView animatableScrollView;
        if (this.mDialog != null && (animatableScrollView = (AnimatableScrollView)this.mDialog.findViewById(4608)) != null) {
            animatableScrollView.setTouchDisable(bl);
        }
    }

    public void createDialog() {
        this.calcDialogSize();
        this.mDialog = DFLayoutHelper.createDialog(this.getContext(), this.mDialogWidth, this.mDialogHeight, this.mConnector.getContentSize(), this.mConnector.getContentVerticalAlign(), this.mConnector.getLocale(), this.mConnector.getIsNotDFList(), this.mConnector.getSpeaker(), this.mConnector.getMicrophone(), this.mConnector.getDisplayArea());
        this.initDialog(this.mDialog);
        this.initBottomBar();
    }

    private void initDialog(Dialog dialog) {
        if (dialog != null) {
            dialog.findViewById(104856).addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mListener);
            ((ViewGroup)dialog.findViewById(104856)).addView((View)new DFManager$1(this, dialog.getContext()), 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
            this.getSpeechCtrl().updateMicBtn();
            this.getSpeechCtrl().updateTTSBtn();
            this.updateProgress(dialog);
            this.updateAutoProgressBtn();
            this.updatePrevNextBtn();
            DFUtils.setOnClick(dialog, 8448, this.mListener);
            DFUtils.setOnClick(dialog, 8449, this.mListener);
            DFUtils.setOnClick(dialog, 8452, this.mListener);
            DFUtils.setOnClick(dialog, 8453, this.mListener);
            DFUtils.setOnClick(dialog, 8450, this.mListener);
            DFUtils.setOnClick(dialog, 5121, this.mListener);
            DFUtils.setOnClick(dialog, 4353, this.mListener);
            DFUtils.setOnTouch(dialog, 4608, this.mListener);
            AnimatableScrollView animatableScrollView = (AnimatableScrollView)dialog.findViewById(4608);
            if (animatableScrollView != null) {
                animatableScrollView.setMoveListener(this.mListener);
            }
            dialog.getWindow().getDecorView().setSystemUiVisibility(4102);
            View view = dialog.getWindow().getDecorView();
            view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)new DFManager$2(this, dialog));
        }
    }

    private void initBottomBar() {
        if (this.mConnector.getIsNotDFList() && this.mConnector.getSpeaker() == 2 && (this.mConnector.getMicrophone() == 1 || this.mConnector.getMicrophone() == 2)) {
            View view = this.getDialog().findViewById(8192);
            view.setVisibility(8);
        }
    }

    public void updateProgress(Dialog dialog) {
        if (dialog != null) {
            if (this.mConnector.getIsNotDFList()) {
                DFProgressbar dFProgressbar = (DFProgressbar)dialog.findViewById(8451);
                dFProgressbar.setVisibility(8);
            } else {
                int n = 0;
                int n2 = 0;
                n = (int)(this.mConnector.getSelectedIndex() + 1L);
                n2 = (int)this.mConnector.getCount();
                DFUtils.setProgress(dialog, 8451, n, n2);
                dialog.findViewById(8452).setEnabled(n > 1);
                dialog.findViewById(8453).setEnabled(n < n2);
            }
        }
    }

    public void showDialog() {
        if (this.mDialog != null && !this.mDialog.isShowing()) {
            this.mDialog.show();
        }
    }

    public void moveComponentInGroup() {
        if (this.mConnector.getType() == 4) {
            this.mCompCtrl.setComponentMoving(false);
            this.mCompCtrl.setFocus();
            this.updateProgress(this.getDialog());
        }
    }

    public void updateHighlight(boolean bl) {
        this.mCompCtrl.updateHighlight(bl);
    }

    public void updateModel(String string, String string2, int n) {
        this.mCompCtrl.updateModel(string, string2, n);
    }

    public void notifyKillFocus(String string, long l) {
        this.mCompCtrl.notifyKillFocus(string, l);
    }

    public void updateLayout(boolean bl, boolean bl2) {
        switch (this.mConnector.getType()) {
            case 0: 
            case 4: {
                long l = this.mConnector.getObjectAddress();
                new Handler().postDelayed((Runnable)new DFManager$3(this, l), 1000L);
                this.getDFHandler().requestCreateComp(bl, bl2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                new Handler().postDelayed((Runnable)new DFManager$4(this), 1000L);
                this.getDFHandler().requestCreateComp(bl, bl2);
                break;
            }
        }
    }

    private boolean onTouch_ScrollView(ScrollView scrollView, MotionEvent motionEvent) {
        AnimatableScrollView animatableScrollView = (AnimatableScrollView)scrollView;
        if (animatableScrollView.isTouchDisable()) {
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        switch (motionEvent.getAction()) {
            case 0: {
                this.mEnableNext = !scrollView.canScrollVertically(5);
                boolean bl = this.mEnablePrev = !scrollView.canScrollVertically(-5);
                if (!this.mEnableNext && !this.mEnablePrev) break;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
                this.mVelocityTracker.addMovement(motionEvent);
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1);
                float f2 = this.mVelocityTracker.getYVelocity();
                if (this.mHandler.hasMoveRequest()) break;
                if (this.mEnableNext && this.mCompCtrl.canNextComp(4) && f2 < -5.0f) {
                    this.mEnableNext = false;
                    this.mEnablePrev = false;
                    this.mHandler.requestMoveNextComp(4);
                    break;
                }
                if (!this.mEnablePrev || !this.mCompCtrl.canPrevComp(4) || !(f2 > 5.0f)) break;
                this.mEnableNext = false;
                this.mEnablePrev = false;
                this.mHandler.requestMovePrevComp(4);
                break;
            }
            case 1: 
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return this.mVelocityTracker != null && !this.mEnableNext && !this.mEnablePrev;
    }

    public void callOnResult(DFEFormBotCtrl$FromSTTInfo dFEFormBotCtrl$FromSTTInfo) {
        if (dFEFormBotCtrl$FromSTTInfo != null) {
            boolean bl = dFEFormBotCtrl$FromSTTInfo.view != null && dFEFormBotCtrl$FromSTTInfo.view == this.getCompCtrl().getCurrentView();
            switch (dFEFormBotCtrl$FromSTTInfo.code) {
                case -2: 
                case 0: {
                    if (!bl) break;
                    if (this.getCompCtrl().getCurrentView() != null && dFEFormBotCtrl$FromSTTInfo.type.equalsIgnoreCase("timestamp")) {
                        Long l = Long.parseLong(dFEFormBotCtrl$FromSTTInfo.text);
                        Date date = new Date(l);
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        String string = simpleDateFormat.format(date);
                        this.bubbleUpdate(string, true, 1, false);
                    } else {
                        this.bubbleUpdate(dFEFormBotCtrl$FromSTTInfo.text, true, 1, false);
                    }
                    this.mCompCtrl.setCompValue(dFEFormBotCtrl$FromSTTInfo.value);
                    if (this.mUseAutoNow && this.mConnector.getSelectedIndex() < this.mConnector.getCount() - 1L) {
                        if (!this.mCompCtrl.canNextComp(2) || this.mHandler.hasMoveRequest()) break;
                        this.mHandler.requestMoveNextComp(2, 1000);
                        break;
                    }
                    if (this.mSpeechCtrl == null) {
                        return;
                    }
                    this.mSpeechCtrl.getMicBtnManager().setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
                    break;
                }
                case 1: {
                    if (this.mCompCtrl.canPrevComp(2) && !this.mHandler.hasMoveRequest()) {
                        this.mHandler.requestMovePrevComp(2);
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 6: {
                    if (this.mCompCtrl.canNextComp(2) && !this.mHandler.hasMoveRequest()) {
                        this.mHandler.requestMoveNextComp(2);
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 2: {
                    if (this.mCompCtrl.canNextComp(2) && !this.mHandler.hasMoveRequest()) {
                        this.mHandler.requestMoveNextComp(2);
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 200: {
                    if (this.mSpeechCtrl != null && this.mSpeechCtrl.isUseTTS() && this.mSpeechCtrl.isUseTTSNow()) {
                        this.mHandler.requestTTS("\uc11c\ubc84\uc5d0 \uc5f0\uacb0\ud558\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case 4: {
                    this.callDismissDialog();
                    break;
                }
                case -1: 
                case 3: 
                case 5: {
                    if (this.mSpeechCtrl != null && this.mSpeechCtrl.isUseTTS() && this.mSpeechCtrl.isUseTTSNow()) {
                        this.mHandler.requestTTS(this.mConnector.getAskAgainText());
                        break;
                    }
                    this.cancelSpeechAndBubble();
                    break;
                }
                case -3: {
                    DFUtils.d("cancel");
                    this.cancelSpeech();
                    this.bubbleUpdate(dFEFormBotCtrl$FromSTTInfo.value.toString(), true, 1, false);
                    break;
                }
            }
        }
    }

    private void OnAutoProgressToggle() {
        this.OnAutoProgressChanged(this.mUseAuto & !this.mUseAutoNow);
    }

    private void OnAutoProgressChanged(boolean bl) {
        if (this.mUseAutoNow != bl) {
            this.mUseAutoNow = bl;
            this.updateAutoProgressBtn();
        }
    }

    private void updateAutoProgressBtn() {
        View view;
        Dialog dialog = this.getDialog();
        if (dialog != null && (view = dialog.findViewById(8450)) != null) {
            view.setSelected(this.mUseAuto & this.mUseAutoNow);
        }
    }

    private void updatePrevNextBtn() {
        Dialog dialog = this.getDialog();
        if (dialog != null && this.mConnector.getIsNotDFList()) {
            View view = dialog.findViewById(8452);
            if (view != null) {
                view.setVisibility(4);
            }
            if ((view = dialog.findViewById(8453)) != null) {
                view.setVisibility(4);
            }
        }
    }

    private void onConfigurationChangedCustom(Configuration configuration) {
        this.mHandler.postDelayed(new DFManager$5(this), 50L);
    }

    public boolean isNotDFList() {
        return this.mConnector != null && this.mConnector.getIsNotDFList();
    }

    public void callForceAnimation(AnimatableScrollView animatableScrollView, View view, boolean bl) {
        this.mListener.OnStartMove(animatableScrollView, animatableScrollView.getContentView(), view, null, bl);
        this.mListener.OnAfterMove(animatableScrollView, animatableScrollView.getContentView(), view, null, bl);
        this.mListener.OnFinishMove(animatableScrollView, animatableScrollView.getContentView(), view, null, bl);
    }

    public String getLocale() {
        return this.mListener.getLocale();
    }

    public void dismiss() {
        OZSpeechManager.getInstance(((Activity)this.mContext).getBaseContext()).clearInstance();
        this.mListener.dismiss();
        if (this.mDialog != null) {
            AnimatableScrollView animatableScrollView = (AnimatableScrollView)this.mDialog.findViewById(4608);
            if (animatableScrollView != null) {
                animatableScrollView.dispose();
            }
            this.mDialog.setContentView(new View(this.getContext()));
        }
    }

    static /* synthetic */ boolean access$000(DFManager dFManager) {
        return dFManager.mUseLayoutChange;
    }

    static /* synthetic */ int access$100(DFManager dFManager) {
        return dFManager.mDialogWidth;
    }

    static /* synthetic */ int access$200(DFManager dFManager) {
        return dFManager.mDialogHeight;
    }

    static /* synthetic */ void access$300(DFManager dFManager, Configuration configuration) {
        dFManager.onConfigurationChangedCustom(configuration);
    }

    static /* synthetic */ void access$400(DFManager dFManager) {
        dFManager.OnAutoProgressToggle();
    }

    static /* synthetic */ boolean access$500(DFManager dFManager, ScrollView scrollView, MotionEvent motionEvent) {
        return dFManager.onTouch_ScrollView(scrollView, motionEvent);
    }

    static /* synthetic */ DFInfoConnector access$600(DFManager dFManager) {
        return dFManager.mConnector;
    }

    static /* synthetic */ DFSpeechCtrl access$700(DFManager dFManager) {
        return dFManager.mSpeechCtrl;
    }

    static /* synthetic */ DFHandler access$800(DFManager dFManager) {
        return dFManager.mHandler;
    }

    static /* synthetic */ boolean access$900(DFManager dFManager) {
        return dFManager.calcDialogSize();
    }

    static /* synthetic */ boolean access$002(DFManager dFManager, boolean bl) {
        dFManager.mUseLayoutChange = bl;
        return dFManager.mUseLayoutChange;
    }
}

