/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.ctrl;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import oz.util.view.animatable.AnimatableScrollView;
import oz.viewer.ui.df.DFHandler;
import oz.viewer.ui.df.DFInfoConnector;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.ctrl.DFInterfaceInflaterView;
import oz.viewer.ui.df.view.DFInflaterView;
import oz.viewer.ui.df.view.DFLayoutHelper;
import oz.viewer.ui.df.view.DFLayoutRootTitleView;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFCompCtrl {
    private DFManager mManager;
    private WeakReference mInflaterView = null;
    private boolean mIsComponetMoving;

    public DFCompCtrl(DFManager dFManager) {
        this.mManager = dFManager;
        this.mIsComponetMoving = false;
    }

    public Context getContext() {
        return this.mManager.getContext();
    }

    public DFInfoConnector getConnector() {
        return this.mManager.getConnector();
    }

    public boolean canNextComp(int n) {
        return this.getConnector().canNextComp(n);
    }

    public boolean canPrevComp(int n) {
        return this.getConnector().canPrevComp(n);
    }

    public boolean canConfirmNext() {
        return this.getConnector().canConfirmNext();
    }

    public void OnNextComp(int n) {
        Dialog dialog = this.mManager.getDialog();
        if (dialog != null && this.canNextComp(n)) {
            this.getConnector().setMessageHandlerWaitFlag(true);
            this.saveValue();
            this.performPrevNextComp(false, n);
        } else if (n == 1) {
            this.getConnector().setMessageHandlerWaitFlag(false);
            this.getConnector().callNextDFMessage();
        }
    }

    public void OnPrevComp(int n) {
        Dialog dialog = this.mManager.getDialog();
        if (dialog != null && this.canPrevComp(n)) {
            this.getConnector().setMessageHandlerWaitFlag(true);
            this.saveValue();
            this.performPrevNextComp(true, n);
        }
    }

    private void performPrevNextComp(boolean bl, int n) {
        boolean bl2 = ((DFInflaterView)this.mInflaterView.get()).nativeFindScriptMessageBox();
        boolean bl3 = ((DFInflaterView)this.mInflaterView.get()).nativeFindScriptSetFocus();
        if (!bl2) {
            this.callKillFocusEvent();
            this.getConnector().setMessageHandlerWaitFlag(false);
            this.disposeCompView(false);
            this.mManager.cancelSpeechAndBubble();
            this.mManager.getDFHandler().removeMessages(18);
            if (!bl3) {
                if (bl) {
                    this.getConnector().onPrevComp(n);
                } else {
                    this.getConnector().onNextComp(n);
                }
            } else {
                this.getConnector().setMessageHandlerWaitFlag(false);
                this.getConnector().callNextDFMessage();
            }
        } else {
            this.getConnector().setMessageHandlerWaitFlag(false);
            this.getConnector().callNextDFMessage();
            this.getConnector().setMessageHandlerWaitFlag(true);
            if (!bl3) {
                if (bl) {
                    this.getConnector().onPrevComp(n);
                } else {
                    this.getConnector().onNextComp(n);
                }
            }
        }
    }

    public DFInflaterView getCurrentView() {
        if (this.mInflaterView != null) {
            return (DFInflaterView)this.mInflaterView.get();
        }
        return null;
    }

    public void setCompValue(Object object) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.setValue(object);
        }
    }

    public boolean saveValue() {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            return dFInflaterView.save();
        }
        return false;
    }

    public void callKillFocusEvent() {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.callKillFocusEvent();
        }
    }

    public void callKillFocusWithSave() {
        this.saveValue();
        this.callKillFocusEvent();
    }

    public void compUpdate(boolean bl, boolean bl2) {
        this.mManager.getDFHandler().requestCreateComp(bl, bl2);
    }

    public void disposeCompView(boolean bl) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (bl && dFInflaterView != null) {
            dFInflaterView.dispose(bl);
            this.mInflaterView = null;
        }
    }

    public void updateCompView() {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            Dialog dialog = this.mManager.getDialog();
            DFInfoConnector dFInfoConnector = this.getConnector();
            ViewGroup viewGroup = (ViewGroup)dialog.findViewById(4882);
            int n = this.mManager.getDialogWidth() - DFUtils.toDP(this.getContext(), 80.0f);
            int n2 = n - (viewGroup != null ? viewGroup.getPaddingLeft() + viewGroup.getPaddingRight() : 0);
            int n3 = this.mManager.getDialogHeight();
            dFInflaterView.update(n2, n3);
        }
    }

    public void createComp(boolean bl, boolean bl2) {
        Object object;
        Dialog dialog = this.mManager.getDialog();
        this.mManager.updateProgress(dialog);
        this.mManager.getSpeechCtrl().setStopNextSpeech(false);
        this.mManager.getSpeechCtrl().clearAutoAskAgainStack();
        DFInfoConnector dFInfoConnector = this.getConnector();
        ViewGroup viewGroup = (ViewGroup)dialog.findViewById(4882);
        ViewGroup viewGroup2 = DFLayoutHelper.createContentBaseLayout(this.getContext());
        ViewGroup viewGroup3 = (ViewGroup)viewGroup2.findViewById(4882);
        int n = this.mManager.getDialogWidth() - DFUtils.toDP(this.getContext(), 80.0f);
        int n2 = n - (viewGroup != null ? viewGroup.getPaddingLeft() + viewGroup.getPaddingRight() : 0);
        int n3 = this.mManager.getDialogHeight();
        this.updateTopTitle(dialog, dFInfoConnector);
        this.updateGroupTitle(dialog, dFInfoConnector);
        DFInflaterView dFInflaterView = new DFInflaterView(this.getContext(), new DFInterfaceInflaterView(this.mManager));
        dFInflaterView.setShowRootTitle(this.isShowDisplayName(dialog));
        dFInflaterView.update(n2, n3);
        viewGroup3.addView((View)dFInflaterView);
        if (this.mInflaterView != null) {
            object = ((DFInflaterView)this.mInflaterView.get()).getCurrentCompView();
            if (object != null) {
                ((DFLayoutView)object).script(13, null);
            }
            ((DFInflaterView)this.mInflaterView.get()).clearNative();
            ((DFInflaterView)this.mInflaterView.get()).removeAllViews();
            this.mInflaterView = null;
        }
        this.mInflaterView = new WeakReference<DFInflaterView>(dFInflaterView);
        object = (AnimatableScrollView)dialog.findViewById(4608);
        if (bl) {
            ((AnimatableScrollView)object).doMoveNextView((View)viewGroup2, 700, bl2);
        } else {
            if (viewGroup != null) {
                ((AnimatableScrollView)object).getContentView().removeAllViews();
                ((AnimatableScrollView)object).clearOldView();
            }
            ((AnimatableScrollView)object).addChildInContentView((View)viewGroup2, DFLayoutHelper.getContextVerticalAling());
            this.mManager.callForceAnimation((AnimatableScrollView)object, (View)viewGroup2, bl2);
        }
    }

    public void clearComp() {
        this.disposeCompView(true);
    }

    private boolean isShowDisplayName(Dialog dialog) {
        if (dialog != null) {
            TextView textView = (TextView)dialog.findViewById(4355);
            return textView != null && textView.isShown();
        }
        return false;
    }

    private void updateTopTitle(Dialog dialog, DFInfoConnector dFInfoConnector) {
        this.updateDisplayName(dialog, dFInfoConnector);
        this.updateTitle(dialog, dFInfoConnector);
    }

    private void updateDisplayName(Dialog dialog, DFInfoConnector dFInfoConnector) {
        if (dialog != null) {
            TextView textView = (TextView)dialog.findViewById(4355);
            if (dFInfoConnector.isShowDisplayName()) {
                textView.setVisibility(0);
                textView.setText((CharSequence)dFInfoConnector.getDisplayName());
            } else {
                textView.setVisibility(8);
            }
        }
    }

    private void updateTitle(Dialog dialog, DFInfoConnector dFInfoConnector) {
        if (dialog != null) {
            int n = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.CONTENTS_TITLE_SHAPE_TYPE);
            DFLayoutRootTitleView dFLayoutRootTitleView = (DFLayoutRootTitleView)dialog.findViewById(4354);
            if (dFLayoutRootTitleView != null) {
                dFLayoutRootTitleView.setText(dFInfoConnector.getTitle());
            }
            if (this.isShowDisplayName(dialog) || dFLayoutRootTitleView != null && dFInfoConnector.getTitle().trim().isEmpty()) {
                dFLayoutRootTitleView.setVisibility(8);
            } else {
                dFLayoutRootTitleView.setVisibility(0);
            }
        }
    }

    private void updateGroupTitle(Dialog dialog, DFInfoConnector dFInfoConnector) {
        LinearLayout linearLayout = (LinearLayout)dialog.findViewById(4356);
        if (dFInfoConnector.getType() == 4) {
            linearLayout.setVisibility(0);
        } else {
            linearLayout.setVisibility(8);
        }
    }

    public void updateGroupFixedLine(Dialog dialog, boolean bl) {
        LinearLayout linearLayout = (LinearLayout)dialog.findViewById(4359);
        if (linearLayout != null) {
            if (bl) {
                linearLayout.setVisibility(0);
            } else {
                linearLayout.setVisibility(8);
            }
        }
    }

    public void attachUpdate(boolean bl, String string) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.onActivityResult(bl, string);
        }
    }

    public boolean attachUpdate(boolean bl, byte[] byArray, int n, String string, String string2, int n2, int n3) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            return dFInflaterView.onActivityResult(bl, byArray, n, string, string2, n2, n3);
        }
        return false;
    }

    public void requestOnMove(boolean bl, int n) {
        boolean bl2;
        DFHandler dFHandler = this.mManager.getDFHandler();
        boolean bl3 = !dFHandler.hasMoveRequest() && (bl ? this.canPrevComp(n) : this.canNextComp(n)) ? true : (bl2 = false);
        if (bl2) {
            if (bl) {
                dFHandler.requestMovePrevComp(n);
            } else {
                dFHandler.requestMoveNextComp(n);
            }
        }
    }

    public void OnMovePrevBtnClick(int n) {
        if (!this.isComponentMoving()) {
            this.setComponentMoving(true);
            this.requestOnMove(true, n);
        }
    }

    public void OnMoveNextBtnClick(int n) {
        if (!this.isComponentMoving()) {
            this.setComponentMoving(true);
            this.requestOnMove(false, n);
        }
    }

    public void requestInputStart(boolean bl) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.requestInputStart(bl);
        }
    }

    public void requestInputEnd() {
        this.requestInputEnd(null);
    }

    public void requestInputEnd(View view) {
        DFInflaterView dFInflaterView;
        if (view != null) {
            dFInflaterView = (InputMethodManager)this.getContext().getSystemService("input_method");
            dFInflaterView.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        if ((dFInflaterView = this.getCurrentView()) != null) {
            dFInflaterView.requestInputEnd();
        }
    }

    public void imagePickerPickedImageResult(boolean bl, Object object) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.onActivityResult(!bl, object);
        }
    }

    public void setFocus() {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.setFocus();
        }
    }

    public void updateHighlight(boolean bl) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.updateHighlight(bl);
        }
    }

    public void updateModel(String string, String string2, int n) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.updateModel(string, string2, n);
        }
    }

    public void notifyKillFocus(String string, long l) {
        DFInflaterView dFInflaterView = this.getCurrentView();
        if (dFInflaterView != null) {
            dFInflaterView.notifyKillFocus(string, l);
        }
    }

    public boolean isComponentMoving() {
        return this.mIsComponetMoving;
    }

    public void setComponentMoving(boolean bl) {
        this.mIsComponetMoving = bl;
    }
}

