/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.ctrl;

import android.app.Dialog;
import android.view.View;
import android.widget.Button;
import oz.util.speech.OZSpeechManager;
import oz.util.speech.OZSpeechRequestInfo;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.ctrl.DFSpeechCtrl$1;
import oz.viewer.ui.df.ctrl.DFSpeechCtrl$2;
import oz.viewer.ui.df.ctrl.DFSpeechCtrl$MicBtnManager;
import oz.viewer.ui.df.ctrl.DFSpeechCtrl$MuteManager;
import oz.viewer.ui.df.view.DFMicBtnView$MIC_STATE;

public class DFSpeechCtrl {
    private DFManager mManager;
    private DFSpeechCtrl$MicBtnManager mMicBtnManager;
    private DFSpeechCtrl$MuteManager mMuteManager;
    private OZSpeechRequestInfo mCurrentSpeech;
    private boolean mCurrentSpeechTTS;
    private boolean mUseSTT;
    private boolean mUseTTS;
    private boolean mUseSTTNow;
    private boolean mUseTTSNow;
    private boolean mCanShowMicBtn;
    private boolean mStopNextSpeech;
    private String currentPartialResult;
    private int autoAskAgainStack;
    private final int ASKAGAIN_LIMIT = 3;
    private static int ADJUST_MUTE = -100;
    private static int ADJUST_UNMUTE = 100;

    public DFSpeechCtrl(DFManager dFManager) {
        this.mManager = dFManager;
        this.mUseSTT = this.mManager.getConnector().getMicrophone() != 2;
        this.mUseTTS = this.mManager.getConnector().getSpeaker() != 2;
        this.mUseSTTNow = this.mManager.getConnector().getMicrophone() == 0;
        this.mUseTTSNow = this.mManager.getConnector().getSpeaker() == 0;
        this.mCanShowMicBtn = true;
        this.mStopNextSpeech = false;
        this.mMicBtnManager = new DFSpeechCtrl$MicBtnManager(this, this.mManager);
        this.mMuteManager = new DFSpeechCtrl$MuteManager(this, this.mManager.getContext());
    }

    public DFSpeechCtrl$MicBtnManager getMicBtnManager() {
        return this.mMicBtnManager;
    }

    public void setCanShowMicBtn(boolean bl) {
        this.mCanShowMicBtn = bl;
    }

    public boolean canShowMicBtn() {
        return this.isUseSTT() && this.isUseSTTNow() && this.mCanShowMicBtn && !this.mStopNextSpeech;
    }

    public void updateMicBtn() {
        Dialog dialog = this.mManager.getDialog();
        if (dialog != null) {
            View view = dialog.findViewById(5121);
            View view2 = dialog.findViewById(5122);
            if (view != null && view2 != null) {
                if (this.mUseSTT) {
                    view.setVisibility(this.canShowMicBtn() ? 0 : 8);
                    view2.setVisibility(this.canShowMicBtn() ? 0 : 8);
                } else {
                    view.setVisibility(8);
                    view2.setVisibility(8);
                }
            }
        }
    }

    public void updateTTSBtn() {
        Button button;
        Dialog dialog = this.mManager.getDialog();
        if (dialog != null && (button = (Button)dialog.findViewById(8448)) != null) {
            if (this.mUseTTS) {
                button.setSelected(this.mUseTTSNow);
            } else {
                button.setVisibility(8);
            }
        }
    }

    public boolean isUseSTT() {
        return this.mUseSTT;
    }

    public boolean isUseSTTNow() {
        return this.mUseSTTNow && !this.mStopNextSpeech;
    }

    public boolean isUseTTS() {
        return this.mUseTTS;
    }

    public boolean isUseTTSNow() {
        return this.mUseTTSNow;
    }

    public void setStopNextSpeech(boolean bl) {
        this.mStopNextSpeech = bl;
        if (this.mStopNextSpeech && OZSpeechManager.getInstance(null).getSpeechStatus() == 1) {
            this.mManager.cancelSpeechAndBubble();
        }
    }

    public boolean getStopNextSpeech() {
        return this.mStopNextSpeech;
    }

    public void requestTTS(String string) {
        this.mCurrentSpeechTTS = true;
        this.mCurrentSpeech = OZSpeechRequestInfo.obtainTTSRequest(string, new DFSpeechCtrl$1(this));
        OZSpeechManager.getInstance(null).addRequest(this.mCurrentSpeech);
    }

    public void requestSTT() {
        this.currentPartialResult = "";
        this.mCurrentSpeechTTS = false;
        this.mCurrentSpeech = OZSpeechRequestInfo.obtainSTTRequest(new DFSpeechCtrl$2(this));
        OZSpeechManager.getInstance(null).addRequest(this.mCurrentSpeech);
    }

    public void clearAutoAskAgainStack() {
        this.autoAskAgainStack = 0;
    }

    private void afterCancelSTT(String string) {
        this.mMuteManager.setMute(false);
        if (string.equals("")) {
            this.cancelCurrent();
            this.mMicBtnManager.setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_COMPLETE);
        } else {
            this.mMicBtnManager.setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_PROCESSING);
            this.mManager.getEFormBotCtrl().eformRequestRecognition(this.mManager.getConnector().getJsonString(string, ""), this.mManager.getConnector().getObjectAddress());
        }
    }

    public void cancelAll() {
        if (this.mCurrentSpeech != null) {
            this.mMicBtnManager.clearMessage();
            this.mMuteManager.clearMessage();
            this.mMuteManager.setMute(false);
            OZSpeechManager.getInstance(null).dispose();
            this.mCurrentSpeech = null;
        }
    }

    public void cancelCurrent() {
        if (this.mCurrentSpeech != null) {
            this.mManager.cancelSpeech(this.mCurrentSpeech);
        }
    }

    public void cancelTTS() {
        if (this.mCurrentSpeechTTS) {
            this.cancelCurrent();
        }
    }

    public void cancelSTT() {
        if (!this.mCurrentSpeechTTS) {
            this.cancelCurrent();
        }
    }

    public void OnUseTTSChanged(boolean bl) {
        if (this.mUseTTSNow != bl) {
            this.mUseTTSNow = this.mUseTTS & bl;
            this.cancelTTS();
            this.updateTTSBtn();
        }
    }

    public void OnUseSTTChanged(boolean bl) {
        if (this.mUseSTTNow != bl) {
            this.mUseSTTNow = this.mUseSTT & bl;
            this.cancelSTT();
            this.updateMicBtn();
            this.onSTTBtnClick(null);
        }
    }

    public void OnTTSAllowBtnClick() {
        if (this.isUseTTS()) {
            boolean bl = !this.isUseTTSNow();
            this.mManager.getDFHandler().requestUseTTSChanged(!this.isUseTTSNow());
            this.mManager.getConnector().setSpeakerOpt(bl ? 0 : 1);
        }
    }

    public void OnSTTAllowBtnClick() {
        if (this.isUseSTT()) {
            this.mManager.getDFHandler().requestUseSTTChanged(!this.isUseSTTNow());
        }
    }

    public void onSTTBtnClick(View view) {
        if (this.isUseSTT() && this.isUseSTTNow()) {
            switch (OZSpeechManager.getInstance(null).getSpeechStatus()) {
                case 1: {
                    this.afterCancelSTT(this.currentPartialResult);
                    break;
                }
                case 2: {
                    this.cancelCurrent();
                    this.mMicBtnManager.setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_START);
                    this.mManager.getDFHandler().requestSTTDelay();
                    break;
                }
                case 0: {
                    if (this.mMicBtnManager.getMicBtnState() == DFMicBtnView$MIC_STATE.LISTEN_PROCESSING) {
                        return;
                    }
                    this.mMicBtnManager.setMicBtnState(DFMicBtnView$MIC_STATE.LISTEN_START);
                    this.mManager.getDFHandler().requestSTT();
                }
            }
        }
    }

    static /* synthetic */ DFSpeechCtrl$MicBtnManager access$000(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mMicBtnManager;
    }

    static /* synthetic */ boolean access$100(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mUseSTT;
    }

    static /* synthetic */ boolean access$200(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mUseSTTNow;
    }

    static /* synthetic */ boolean access$300(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mStopNextSpeech;
    }

    static /* synthetic */ DFManager access$400(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mManager;
    }

    static /* synthetic */ DFSpeechCtrl$MuteManager access$500(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mMuteManager;
    }

    static /* synthetic */ OZSpeechRequestInfo access$602(DFSpeechCtrl dFSpeechCtrl, OZSpeechRequestInfo oZSpeechRequestInfo) {
        dFSpeechCtrl.mCurrentSpeech = oZSpeechRequestInfo;
        return dFSpeechCtrl.mCurrentSpeech;
    }

    static /* synthetic */ boolean access$700(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mUseTTS;
    }

    static /* synthetic */ boolean access$800(DFSpeechCtrl dFSpeechCtrl) {
        return dFSpeechCtrl.mUseTTSNow;
    }

    static /* synthetic */ int access$904(DFSpeechCtrl dFSpeechCtrl) {
        return ++dFSpeechCtrl.autoAskAgainStack;
    }

    static /* synthetic */ String access$1002(DFSpeechCtrl dFSpeechCtrl, String string) {
        dFSpeechCtrl.currentPartialResult = string;
        return dFSpeechCtrl.currentPartialResult;
    }

    static /* synthetic */ int access$1200() {
        return ADJUST_MUTE;
    }

    static /* synthetic */ int access$1300() {
        return ADJUST_UNMUTE;
    }
}

