/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.model.label;

import org.json.JSONObject;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;

public class DFLabelModel {
    public String text;
    public int number = -1;
    public int textSize;
    public int textColor;
    public int style;
    public int gravity;
    public boolean isVisible = true;
    public boolean isEnable = true;
    public boolean isRequired = false;
    public boolean isGroup = false;
    public boolean useHighlightTextColor = false;
    public boolean isNotDFList = false;
    public String requiredText;
    public String optionalText;
    public int requiredTextColor;
    public int optionalTextColor;
    public int dftype;
    public int type = 0;

    public DFLabelModel() {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.requiredText = (String)DFStyleManager.getInstance().getStyle(DFStyleManager.COMMON_REQUIRED_TEXT);
        this.optionalText = (String)DFStyleManager.getInstance().getStyle(DFStyleManager.COMMON_OPTIONAL_TEXT);
        this.requiredTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.COMMON_REQUIRED_TEXT_COLOR));
        this.optionalTextColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.COMMON_OPTIONAL_TEXT_COLOR));
    }

    public void setAttribute(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.setAttribute(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n, boolean bl, boolean bl2) {
        this.type = n;
        this.useHighlightTextColor = bl;
        this.isNotDFList = bl2;
    }

    public void setAttribute(JSONObject jSONObject) {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        switch (this.type) {
            case 1: {
                this.textColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_QUESTION_FONT_COLOR));
                this.style = DFUtils.getTextTypeFace((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_QUESTION_FONT_STYLE));
                this.gravity = DFUtils.getTextGravity((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_QUESTION_TEXT_ALIGNMENT));
                if (!jSONObject.isNull("questionnumber")) {
                    this.number = jSONObject.optInt("questionnumber");
                }
                if (jSONObject.isNull("question")) break;
                this.text = jSONObject.optString("question");
                break;
            }
            case 2: {
                this.textColor = DFUtils.getRGB((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DESCRIPTION_FONT_COLOR));
                this.style = DFUtils.getTextTypeFace((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DESCRIPTION_FONT_STYLE));
                this.gravity = DFUtils.getTextGravity((Integer)dFStyleManager.getStyle(DFStyleManager.CONTENTS_DESCRIPTION_TEXT_ALIGNMENT));
                if (jSONObject.isNull("description")) break;
                this.text = jSONObject.optString("description");
            }
        }
        if (!jSONObject.isNull("visible")) {
            this.isVisible = jSONObject.optBoolean("visible");
        }
        if (!jSONObject.isNull("enable")) {
            this.isEnable = jSONObject.optBoolean("enable");
        }
        if (!jSONObject.isNull("isrequired")) {
            this.isRequired = jSONObject.optBoolean("isrequired");
        }
        if (!jSONObject.isNull("dftype")) {
            this.dftype = jSONObject.optInt("dftype", -1);
        }
        if (!jSONObject.isNull("isgroup")) {
            this.isGroup = jSONObject.optBoolean("isgroup");
        }
    }
}

