/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.check;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.check.DFCheckInterface;
import oz.viewer.ui.df.mvvm.views.check.DFCheckViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFCheckButtonView;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFCheckView
extends DFLayoutView
implements View.OnClickListener {
    private DFCheckViewModel viewModel;
    private DFCheckButtonView mYesBtn;
    private DFCheckButtonView mNoBtn;
    LinearLayout mCheckLayout;
    private DFCheckInterface mDFCheckInterface;
    private boolean isChangeAttribute = false;
    static final int BUTTON_LEFT_PADDING = 20;

    public DFCheckView(Context context, DFCheckViewModel dFCheckViewModel, DFCheckInterface dFCheckInterface) {
        super(context);
        this.mDFCheckInterface = dFCheckInterface;
        this.setViewModel(dFCheckViewModel);
        this.initView();
        this.setVisibility(4);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (bl) {
            this.setVisibility(0);
            this.updateView();
        }
    }

    public void setDFClickListener(View.OnClickListener onClickListener) {
        this.mNoBtn.setEnabled(true);
        this.mYesBtn.setEnabled(true);
    }

    public void setViewModel(DFCheckViewModel dFCheckViewModel) {
        this.viewModel = dFCheckViewModel;
    }

    private void initView() {
        this.mCheckLayout = new LinearLayout(this.getContext());
        this.mCheckLayout.setOrientation(0);
        this.mCheckLayout.setGravity(16);
        DFButtonViewModel dFButtonViewModel = new DFButtonViewModel(this.viewModel.buttonModel);
        this.mNoBtn = new DFCheckButtonView(this.getContext(), dFButtonViewModel);
        this.mNoBtn.setOnClickListener(this);
        this.mYesBtn = new DFCheckButtonView(this.getContext(), dFButtonViewModel);
        this.mYesBtn.setOnClickListener(this);
        this.mNoBtn.setText(this.viewModel.checkModel.noText);
        this.mYesBtn.setText(this.viewModel.checkModel.yesText);
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(n, 0, 0, 0);
        if (this.viewModel.checkModel.isRightYes) {
            this.mCheckLayout.addView((View)this.mNoBtn, (ViewGroup.LayoutParams)layoutParams);
            this.mCheckLayout.addView((View)this.mYesBtn, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.mCheckLayout.addView((View)this.mYesBtn, (ViewGroup.LayoutParams)layoutParams);
            this.mCheckLayout.addView((View)this.mNoBtn, (ViewGroup.LayoutParams)layoutParams);
        }
        this.addView((View)this.mCheckLayout, (ViewGroup.LayoutParams)this.getContentLayoutParam());
        this.updateView();
    }

    public void updateDFView(boolean bl, boolean bl2) {
        DFCheckButtonView dFCheckButtonView = bl ? this.mYesBtn : this.mNoBtn;
        DFCheckButtonView dFCheckButtonView2 = bl ? this.mNoBtn : this.mYesBtn;
        dFCheckButtonView.setSelected(true, bl2);
        dFCheckButtonView2.setSelected(false, bl2);
        this.viewModel.isYes = bl;
    }

    public void updateDFView(View view, boolean bl) {
        boolean bl2 = view == this.mYesBtn;
        this.updateDFView(bl2, bl);
    }

    public void onClick(View view) {
        boolean bl = view == this.mYesBtn;
        this.executeEvent(12, null);
        this.updateDFView(bl, false);
        if (!this.viewModel.checkModel.isEndInput) {
            this.executeEvent(14, bl ? "true" : "false");
        }
        this.executeEvent(2, null);
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777211: {
                object2 = String.valueOf(this.viewModel.isYes);
                break;
            }
            case -16777208: {
                String string = (String)object;
                this.viewModel.checkModel.setAttribute(string);
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.checkModel.isEndInput;
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case -16777210: {
                String string = (String)object;
                if (string.equals("::true")) {
                    this.updateDFView(true, true);
                    break;
                }
                if (!string.equals("::false")) break;
                this.updateDFView(false, true);
                break;
            }
        }
        return object2;
    }

    public void updateView() {
        if (!this.isChangeAttribute) {
            this.mCheckLayout.setVisibility(4);
            this.mNoBtn.setText(this.viewModel.checkModel.noText);
            this.mYesBtn.setText(this.viewModel.checkModel.yesText);
            this.mNoBtn.measure(0, 0);
            this.mYesBtn.measure(0, 0);
            this.mCheckLayout.measure(0, 0);
            int n = this.mNoBtn.getMeasuredWidth();
            int n2 = this.mYesBtn.getMeasuredWidth();
            int n3 = DFUtils.toDP(this.getContext(), 20.0f);
            int n4 = this.getWidth() - n3 * 2;
            if (n > 0 && n2 > 0) {
                int n5;
                int n6 = n5 = n > n2 ? n : n2;
                if (n5 * 2 > n4) {
                    n5 = n4 / 2;
                }
                ViewGroup.LayoutParams layoutParams = this.mNoBtn.getLayoutParams();
                ViewGroup.LayoutParams layoutParams2 = this.mYesBtn.getLayoutParams();
                layoutParams.width = n5;
                layoutParams2.width = n5;
                this.mNoBtn.setLayoutParams(layoutParams);
                this.mYesBtn.setLayoutParams(layoutParams2);
            }
            this.updateDFView(this.viewModel.isYes, false);
            this.isChangeAttribute = false;
            this.mCheckLayout.setVisibility(0);
        }
    }
}

