/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.dfbutton;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;

public class DFBaseButtonView
extends FrameLayout {
    private ImageView mImageView;
    public DFButtonViewModel viewModel;

    public DFBaseButtonView(Context context, DFButtonViewModel dFButtonViewModel) {
        super(context);
        this.viewModel = dFButtonViewModel;
        this.init();
    }

    public void setImageResourceID(int n) {
        if (n != 0) {
            this.mImageView.setImageResource(n);
        }
    }

    public void setImageResource(int n) {
        this.mImageView.setBackgroundResource(n);
    }

    public void setImageResource(Drawable drawable2) {
        if (drawable2 != null) {
            this.mImageView.setBackground(drawable2);
        }
    }

    private void init() {
        this.addImageView();
        this.initExtra();
        this.applyRect();
    }

    public ImageView getImageView() {
        return this.mImageView;
    }

    protected ImageView.ScaleType getScaleType() {
        return ImageView.ScaleType.CENTER;
    }

    public void addImageView() {
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setScaleType(this.getScaleType());
        this.addImageView(this.mImageView);
    }

    protected void addImageView(ImageView imageView) {
        this.addView((View)imageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
    }

    protected void initExtra() {
    }

    public void applyRect() {
        this.getBackgroundView().setBackground(this.createDrawable());
    }

    protected View getBackgroundView() {
        return this;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mImageView.setEnabled(bl);
    }

    protected Drawable createDrawable() {
        return DFBaseButtonView.getGDNormalFrame(this.getContext(), this.applayDisableColor(this.getBackgroundColor()), this.applayDisableColor(this.getBorderColor()), this.getBorderThick(), this.viewModel.model.radius);
    }

    protected Drawable createSelectedDrawable() {
        return DFBaseButtonView.getGDNormalFrame(this.getContext(), this.viewModel.model.selectBackgroundColor, this.viewModel.model.selectBorderColor, this.viewModel.model.selectBorderThick, this.viewModel.model.radius);
    }

    protected static GradientDrawable getGDNormalFrame(Context context, int n, int n2, float f2, float f3) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(n);
        gradientDrawable.setStroke(DFUtils.toDP(context, f2), n2);
        f3 = DFUtils.toDP(context, f3);
        if (f3 < 0.0f) {
            f3 = 2.1474836E9f;
        }
        gradientDrawable.setCornerRadius(f3);
        return gradientDrawable;
    }

    public int getBackgroundColor() {
        return this.isSelected() ? this.viewModel.model.selectBackgroundColor : this.viewModel.model.unselectBackgroundColor;
    }

    public int getBorderColor() {
        return this.isSelected() ? this.viewModel.model.selectBorderColor : this.viewModel.model.unselectBorderColor;
    }

    public float getBorderThick() {
        return this.isSelected() ? this.viewModel.model.selectBorderThick : this.viewModel.model.unselectBorderThick;
    }

    public int applayDisableColor(int n) {
        if (!this.isEnabled()) {
            int n2 = Color.alpha((int)n);
            int n3 = DFUtils.getPlaceHolderColor(n);
            n = Color.argb((int)n2, (int)Color.red((int)n3), (int)Color.green((int)n3), (int)Color.blue((int)n3));
        }
        return n;
    }
}

