/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.dfbutton;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFBaseButtonView;
import oz.viewer.ui.df.mvvm.views.dfbutton.DFButtonViewModel;

public class DFListButtonView
extends DFBaseButtonView {
    private static final int DP_PADDING = 12;
    private static final int SP_TEXT_SIZE = 16;
    private LinearLayout mLayout;
    private TextView mTextView;

    public DFListButtonView(Context context, DFButtonViewModel dFButtonViewModel) {
        super(context, dFButtonViewModel);
    }

    protected Drawable createDeselectedDrawable() {
        return super.createDrawable();
    }

    protected Drawable createSelectedDrawable() {
        return super.createSelectedDrawable();
    }

    protected Drawable createDisabledDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)this.createDeselectedDrawable();
        return gradientDrawable;
    }

    protected Drawable createDrawable() {
        Drawable drawable2 = this.createSelectedDrawable();
        Drawable drawable3 = this.createDeselectedDrawable();
        Drawable drawable4 = this.createDisabledDrawable();
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842910}, drawable4);
        stateListDrawable.addState(new int[]{16842919}, drawable2);
        stateListDrawable.addState(new int[]{-16842913}, drawable3);
        stateListDrawable.addState(new int[]{0x10100A1}, drawable2);
        return stateListDrawable;
    }

    protected void addImageView(ImageView imageView) {
        this.mLayout = new LinearLayout(this.getContext());
        this.mLayout.setOrientation(0);
        this.mLayout.setGravity(19);
        int n = DFUtils.toDP(this.getContext(), 12.0f);
        this.mLayout.setPadding(n, n, n, n);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.mLayout.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setTextSize(16.0f);
        this.mTextView.setTextColor(this.viewModel.model.itembuttonFontColor);
        if (this.viewModel.model.textAlignment == 0) {
            this.mTextView.setGravity(3);
        } else if (this.viewModel.model.textAlignment == 1) {
            this.mTextView.setGravity(17);
        } else if (this.viewModel.model.textAlignment == 2) {
            this.mTextView.setGravity(5);
        }
        this.mTextView.setMinimumWidth(DFUtils.toDP(this.getContext(), 10.0f));
        this.mLayout.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 10.0f));
        this.addView((View)this.mLayout);
        this.updateMargin();
    }

    public void setEllipsize() {
        this.mTextView.setMaxLines(1);
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
    }

    public void setText(String string) {
        this.mTextView.setText((CharSequence)string);
        this.updateMargin();
    }

    private void updateMargin() {
        int n;
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.getImageView().getLayoutParams();
        layoutParams.rightMargin = this.viewModel.mHasImage && this.mTextView.getText().length() > 0 ? (n = DFUtils.toDP(this.getContext(), 12.0f)) : 0;
    }

    protected void initExtra() {
        super.initExtra();
    }

    public void setTextColor(int n) {
        this.mTextView.setTextColor(n);
    }

    public void setTextSize(float f2) {
        this.mTextView.setTextSize(f2);
    }

    public void setGravity(int n) {
        this.mTextView.setGravity(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mTextView.setEnabled(bl);
        this.updateTextViewColor();
        this.applyRect();
    }

    public void updateTextViewColor() {
        int n = this.viewModel.model.itembuttonFontColor;
        int n2 = DFUtils.getPlaceHolderColor(n);
        this.mTextView.setTextColor(this.mTextView.isEnabled() ? n : n2);
    }

    public void setSelected(boolean bl, boolean bl2) {
        super.setSelected(bl);
        this.applyRect();
    }
}

