/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.image;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.FrameLayout;
import java.util.HashMap;
import oz.util.view.camera.ImageSealView;
import oz.util.view.camera.ImageSealView$OnSealListener;
import oz.viewer.ui.df.ctrl.DFImageRecognitionData;
import oz.viewer.ui.df.mvvm.views.image.DFBaseImagePickerView;
import oz.viewer.ui.df.mvvm.views.image.DFImageViewModel;

public class DFSealImageView
extends DFBaseImagePickerView
implements ImageSealView$OnSealListener {
    private ImageSealView mImageSealView;
    private Bitmap mBitmap;
    private String mJPGBase64EncodingData;

    public DFSealImageView(Context context, DFImageViewModel dFImageViewModel) {
        super(context, dFImageViewModel);
        this.initView();
        this.updatePickerView();
    }

    private void initView() {
        this.addView((View)this.getContentLayout(-1, 700));
        this.updateButtons();
    }

    public void updateView() {
        this.mImageSealView.setPictureRatio(this.viewModel.imageModel.compRatio);
        this.updatePickerView();
    }

    protected FrameLayout getImagePickerView() {
        this.mImageSealView = new ImageSealView(this.getContext());
        this.mImageSealView.setPictureRatio(this.viewModel.imageModel.compRatio);
        return this.mImageSealView;
    }

    protected void setOnClickListener() {
        super.setOnClickListener();
        this.mImageSealView.setOnTakePictureListener(this);
    }

    public void setBitmapResult(Object object, String string, int n) {
        if (n == 999) {
            if (object != null) {
                this.mBitmap = DFSealImageView.parseValue(string);
                this.mJPGBase64EncodingData = string;
            }
        } else if (n == 997 && object != null) {
            this.mBitmap = (Bitmap)object;
        }
    }

    public int OnTakePreview(DFImageRecognitionData dFImageRecognitionData) {
        int[] nArray = new int[14];
        nArray[0] = dFImageRecognitionData.mRectWidth;
        nArray[1] = dFImageRecognitionData.mRectHeight;
        nArray[2] = dFImageRecognitionData.mRectLeft;
        nArray[3] = dFImageRecognitionData.mRectTop;
        nArray[4] = dFImageRecognitionData.mBitmapWidth;
        nArray[5] = dFImageRecognitionData.mBitmapHeight;
        nArray[6] = dFImageRecognitionData.mRotation;
        nArray[7] = dFImageRecognitionData.mCameraType;
        nArray[8] = dFImageRecognitionData.mIsFocused;
        nArray[9] = dFImageRecognitionData.mIsOnceFocused;
        nArray[10] = dFImageRecognitionData.mIsForceShutter;
        nArray[11] = dFImageRecognitionData.mIsPreview;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("bitmap", dFImageRecognitionData.mBitmap);
        hashMap.put("data", dFImageRecognitionData.mData);
        hashMap.put("infos", nArray);
        hashMap.put("result", null);
        this.executeEvent(-1728053246, hashMap);
        Object v = hashMap.get("result");
        if (v != null && v instanceof Object[]) {
            Object[] objectArray = (Object[])v;
            int n = (Integer)objectArray[0];
            Object object = objectArray[2];
            this.setBitmapResult(object, (String)objectArray[1], n);
            if (object == null && n == 997) {
                n = 998;
            }
            return n;
        }
        return -1;
    }

    public void willShowDialog(Dialog dialog) {
        this.executeEvent(-1728053247, null);
    }

    public void willDismissDialog(Dialog dialog) {
        this.executeEvent(-1728053245, null);
    }

    public void OnTakePicture(Bitmap bitmap) {
        this.setValue(this.mJPGBase64EncodingData, this.mBitmap);
        this.mBitmap = null;
        this.mJPGBase64EncodingData = null;
        this.mImageSealView.dismiss();
    }

    protected void updateBitmap(Bitmap bitmap) {
        this.mImageSealView.setImageBitmap(bitmap);
    }

    public void closeDialog() {
        this.mImageSealView.dismiss();
    }
}

