/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.sign;

import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import oz.client.shape.ui.ICSignPadWndSimple;
import oz.client.shape.ui.OZSignView;

public class DFSignPadViewController {
    public ICSignPadWndSimple signPad;
    public FrameLayout view;
    public View openButton;
    public Button resetButton;
    public Button reusableButton;
    public Boolean isClearSign = false;
    public Boolean isReusabled = false;
    public ViewGroup signPadLayout;
    public boolean alwaysReadOnly = false;
    public boolean showResetButton = true;

    public boolean isShowing() {
        if (this.view != null) {
            return this.view.getVisibility() == 0;
        }
        return false;
    }

    public void show() {
        this.setShow(true);
    }

    public void hide() {
        this.setShow(false);
    }

    public void setShow(boolean bl) {
        int n = 0;
        if (!bl) {
            n = 4;
        }
        if (this.view != null) {
            this.view.setVisibility(n);
        }
        if (this.resetButton != null) {
            if (this.showResetButton) {
                this.resetButton.setVisibility(n);
            } else {
                this.resetButton.setVisibility(4);
            }
        }
    }

    public boolean isEditable() {
        OZSignView oZSignView;
        if (this.signPad != null && (oZSignView = this.signPad.getSimplerSignView()) != null) {
            return oZSignView.isEnabled();
        }
        return false;
    }

    public void setEditable(boolean bl) {
        OZSignView oZSignView;
        boolean bl2;
        boolean bl3 = bl2 = bl && !this.alwaysReadOnly;
        if (this.signPad != null && (oZSignView = this.signPad.getSimplerSignView()) != null) {
            oZSignView.setEnabled(bl2);
        }
        if (this.openButton != null) {
            this.openButton.setClickable(bl2);
        }
    }

    public void setValue(String string) {
        if (string == null) {
            string = "";
        }
        if (this.signPad != null) {
            this.signPad.setComponentData(string);
        }
    }

    public boolean isValueChangedFlag() {
        if (this.signPad != null && this.signPad.getSimplerSignView() != null) {
            return this.signPad.getSimplerSignView().getICParent().isChanged();
        }
        return false;
    }

    public void setValueChangedFlag() {
        if (this.signPad != null && this.signPad.getSimplerSignView() != null) {
            this.signPad.getSimplerSignView().getICParent().changed();
        }
    }

    public void clearValueChangedFlag() {
        if (this.signPad != null && this.signPad.getSimplerSignView() != null) {
            this.signPad.getSimplerSignView().getICParent().notChanged();
        }
    }

    public String getValue() {
        String string = null;
        if (this.signPad != null) {
            string = this.signPad.getComponentData();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void clearValue() {
        if (this.signPadLayout.findViewById(0x7788EE) != null) {
            this.signPadLayout.findViewById(0x7788EE).setVisibility(0);
        }
        this.isClearSign = true;
        this.signPad.clearInputComponentView();
        this.setEditable(true);
        if (this.signPad.getSimplerSignView() != null) {
            this.signPad.getSimplerSignView().getICParent().changed();
        }
    }

    public void updateSignView(int n, int n2) {
        if (this.signPad != null) {
            boolean bl = this.isShowing();
            boolean bl2 = this.isEditable();
            boolean bl3 = this.isValueChangedFlag();
            if (this.signPad.isSignDrawBitmapMode()) {
                Bitmap bitmap = this.signPad.getSignBitmap();
                Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
                this.view = this.signPad.getSimpleSignPadView(n, n2);
                this.signPad.setSignDrawMode(1);
                if (bitmap != null) {
                    this.signPad.setComponentBitmap(bitmap2);
                }
                this.signPad.getSimplerSignView().init();
            } else {
                String string = this.getValue();
                this.view = this.signPad.getSimpleSignPadView(n, n2);
                if (!string.isEmpty()) {
                    this.setValue(string);
                }
                this.setShow(bl);
                this.setEditable(bl2);
                if (bl3) {
                    this.setValueChangedFlag();
                } else {
                    this.clearValueChangedFlag();
                }
            }
        }
    }

    public void updateSignViewBorder(int n, int n2) {
        if (this.signPad != null && this.signPad.getSimplerSignView() != null) {
            this.signPad.getSimplerSignView().setBorderCustomUI(n, n2);
        }
    }
}

