/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.sign;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.model.sign.DFSignModel;
import oz.viewer.ui.df.mvvm.views.sign.DFSignPadViewController;
import oz.viewer.ui.df.mvvm.views.sign.DFSignPadViewControllerMaker;
import oz.viewer.ui.df.mvvm.views.sign.DFSignPadViewControllerMaker$ControllerMakeSpec;
import oz.viewer.ui.df.mvvm.views.sign.DFSignView$1;
import oz.viewer.ui.df.mvvm.views.sign.DFSignView$SignPadListener;
import oz.viewer.ui.df.mvvm.views.sign.DFSignViewModel;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFSignView
extends DFLayoutView {
    DFSignViewModel viewModel;
    LinearLayout root;
    private int signWidth;
    private int signHeight;
    private final int margin = 10;
    private boolean signViewInit;
    private int oldScreenWidth;
    private ArrayList signPadViewList;
    private final DFSignView$SignPadListener mListener;

    public DFSignView(Context context, DFSignViewModel dFSignViewModel) {
        super(context);
        this.viewModel = dFSignViewModel;
        this.mListener = new DFSignView$SignPadListener(this);
        this.initView();
    }

    protected DFSignPadViewController getSignPadViewController(int n) {
        if (n > -1 && n < this.signPadViewList.size()) {
            return (DFSignPadViewController)this.signPadViewList.get(n);
        }
        return null;
    }

    protected int findIndexByController(DFSignPadViewController dFSignPadViewController) {
        int n = -1;
        for (int j = 0; j < this.signPadViewList.size(); ++j) {
            if (this.signPadViewList.get(j) != dFSignPadViewController) continue;
            n = j;
            break;
        }
        return n;
    }

    private void initView() {
        this.signPadViewList = new ArrayList();
        this.root = new LinearLayout(this.getContext());
        this.root.setOrientation(1);
        int n = DFUtils.toDP(this.getContext(), 20.0f);
        int n2 = DFUtils.toDP(this.getContext(), 10.0f);
        this.root.setPadding(n, n2, 0, 0);
        this.addView((View)this.root);
    }

    protected void onInitSignPad(DFSignPadViewController dFSignPadViewController, DFSignPadViewControllerMaker$ControllerMakeSpec dFSignPadViewControllerMaker$ControllerMakeSpec) {
        if (!dFSignPadViewController.isReusabled.booleanValue()) {
            dFSignPadViewController.setValue(dFSignPadViewControllerMaker$ControllerMakeSpec.setting.value);
            dFSignPadViewController.clearValueChangedFlag();
            if (dFSignPadViewControllerMaker$ControllerMakeSpec.setting.value != null && !dFSignPadViewControllerMaker$ControllerMakeSpec.setting.value.isEmpty()) {
                dFSignPadViewController.show();
                dFSignPadViewController.setEditable(false);
            } else {
                dFSignPadViewController.hide();
                dFSignPadViewController.setEditable(true);
            }
        }
    }

    protected DFSignPadViewControllerMaker provideControllerMaker() {
        return new DFSignPadViewControllerMaker();
    }

    protected void onCreateSignPad(boolean bl) {
        Object object;
        if (this.viewModel.isGroup()) {
            for (int j = 0; j < this.viewModel.MAX_SIGN_VIEW; ++j) {
                LinearLayout linearLayout = new LinearLayout(this.getContext());
                linearLayout.setOrientation(0);
                for (int k = 0; k < 2; ++k) {
                    object = new LinearLayout(this.getContext());
                    linearLayout.addView((View)object);
                }
                this.root.addView((View)linearLayout);
            }
        }
        DFSignPadViewControllerMaker dFSignPadViewControllerMaker = this.provideControllerMaker();
        for (int j = 0; j < this.viewModel.getSignCount(); ++j) {
            DFSignPadViewControllerMaker$ControllerMakeSpec dFSignPadViewControllerMaker$ControllerMakeSpec = new DFSignPadViewControllerMaker$ControllerMakeSpec();
            dFSignPadViewControllerMaker$ControllerMakeSpec.id = j;
            dFSignPadViewControllerMaker$ControllerMakeSpec.width = this.signWidth;
            dFSignPadViewControllerMaker$ControllerMakeSpec.height = this.signHeight;
            dFSignPadViewControllerMaker$ControllerMakeSpec.context = this.getContext();
            dFSignPadViewControllerMaker$ControllerMakeSpec.globalSetting = this.viewModel;
            dFSignPadViewControllerMaker$ControllerMakeSpec.baseSetting = this.viewModel.signModel[0];
            dFSignPadViewControllerMaker$ControllerMakeSpec.setting = this.viewModel.signModel[j];
            object = dFSignPadViewControllerMaker.make(dFSignPadViewControllerMaker$ControllerMakeSpec, this.mListener);
            this.signPadViewList.add(object);
            this.onInitSignPad((DFSignPadViewController)object, dFSignPadViewControllerMaker$ControllerMakeSpec);
            if (this.viewModel.isGroup()) {
                LinearLayout.LayoutParams layoutParams;
                if (bl) {
                    layoutParams = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams.setMargins(0, 10, 0, 10);
                    ((LinearLayout)this.root.getChildAt(j)).addView((View)object.signPadLayout, (ViewGroup.LayoutParams)layoutParams);
                    continue;
                }
                layoutParams = new LinearLayout.LayoutParams(this.signWidth, -2);
                layoutParams.setMargins(10, 10, 10, 10);
                ((LinearLayout)((LinearLayout)this.root.getChildAt(j / 2)).getChildAt(j % 2)).addView((View)object.signPadLayout, (ViewGroup.LayoutParams)layoutParams);
                continue;
            }
            this.root.addView((View)object.signPadLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        }
    }

    protected void onSignPadSizeChanged() {
        if (this.viewModel == null || this.viewModel.signModel == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        DFSignModel dFSignModel = null;
        if (this.viewModel.signModel.length > 0) {
            dFSignModel = this.viewModel.signModel[0];
        }
        if (dFSignModel != null) {
            n = dFSignModel.signPadBorderThick;
            n2 = dFSignModel.signPadBorderColor;
        }
        int n3 = 0;
        for (DFSignPadViewController dFSignPadViewController : this.signPadViewList) {
            if (n3 >= this.viewModel.MAX_SIGN_VIEW) break;
            if (!this.viewModel.signModel[n3].isVisible || dFSignPadViewController == null) continue;
            dFSignPadViewController.updateSignView(this.signWidth, this.signHeight);
            dFSignPadViewController.updateSignViewBorder(n, n2);
            ++n3;
        }
    }

    protected void onRotateSignPad(boolean bl) {
        LinearLayout.LayoutParams layoutParams;
        int n;
        for (int j = 0; j < this.viewModel.MAX_SIGN_VIEW; ++j) {
            for (n = 0; n < 2; ++n) {
                ((LinearLayout)((LinearLayout)this.root.getChildAt(j)).getChildAt(n)).removeAllViews();
            }
        }
        if (bl) {
            layoutParams = new LinearLayout.LayoutParams(-2, this.signHeight);
            layoutParams.setMargins(0, 10, 0, 10);
        } else {
            layoutParams = new LinearLayout.LayoutParams(this.signWidth, this.signHeight);
            layoutParams.setMargins(10, 10, 10, 10);
        }
        n = 0;
        for (int j = 0; j < this.viewModel.MAX_SIGN_VIEW; ++j) {
            for (int k = 0; k < 2 && n < this.signPadViewList.size(); ++k) {
                LinearLayout linearLayout = null;
                DFSignPadViewController dFSignPadViewController = this.getSignPadViewController(n);
                linearLayout = bl ? (LinearLayout)((LinearLayout)this.root.getChildAt(n)).getChildAt(0) : (LinearLayout)((LinearLayout)this.root.getChildAt(n / 2)).getChildAt(k % 2);
                if (linearLayout == null) continue;
                ViewGroup viewGroup = (ViewGroup)dFSignPadViewController.signPadLayout.getParent();
                if (viewGroup != null) {
                    viewGroup.removeView((View)dFSignPadViewController.signPadLayout);
                }
                linearLayout.addView((View)dFSignPadViewController.signPadLayout, (ViewGroup.LayoutParams)layoutParams);
                ++n;
            }
        }
    }

    private void updateSignPadSize(int n, int n2) {
        Point point = DFUtils.getScreenSize((Activity)this.getContext());
        boolean bl = point.x < point.y || this.viewModel.isFittoframeVerticalalign();
        boolean bl2 = this.oldScreenWidth != point.x;
        this.oldScreenWidth = point.x;
        this.calcSignPadSize(bl, n, n2);
        if (this.signViewInit) {
            this.onSignPadSizeChanged();
            if (this.viewModel.isGroup() && bl2) {
                this.onRotateSignPad(bl);
            }
        } else {
            this.signViewInit = true;
            this.onCreateSignPad(bl);
        }
    }

    private void calcSignPadSize(boolean bl, int n, int n2) {
        this.signWidth = n;
        this.signHeight = n2;
        if (n2 < 0) {
            this.signHeight = this.signWidth / 4;
        }
        if (this.viewModel.getSignCount() != 1) {
            this.signHeight = DFUtils.toDP(this.getContext(), 150.0f);
            if (!bl) {
                this.signWidth = n / 2 - 20;
            }
        }
    }

    protected void updateSignViewByReusable(int n, boolean bl) {
        this.updateSignViewByReusable(this.getSignPadViewController(n), n, bl);
    }

    protected void updateSignViewByReusable(DFSignPadViewController dFSignPadViewController, int n, boolean bl) {
        if (dFSignPadViewController != null) {
            DFSignModel dFSignModel = null;
            if (this.viewModel != null && n < this.viewModel.signModel.length) {
                dFSignModel = this.viewModel.signModel[n];
            }
            if (dFSignPadViewController != null && dFSignModel != null && dFSignModel.reusableSignData != null && !dFSignModel.reusableSignData.isEmpty()) {
                dFSignPadViewController.isReusabled = true;
                dFSignPadViewController.setValue(dFSignModel.reusableSignData);
                dFSignPadViewController.clearValueChangedFlag();
                dFSignPadViewController.show();
                dFSignPadViewController.setEditable(bl);
                if (!this.viewModel.isEndInput) {
                    this.postDelayed(new DFSignView$1(this), 300L);
                }
            }
        }
    }

    public int[] layout_measure(int n, int n2) {
        if (this.signWidth != n && this.signHeight != n2 && this.getVisibility() != 8) {
            this.updateSignPadSize(n, n2);
        }
        return super.layout_measure(n, n2);
    }

    private String getViewValue() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("count", this.viewModel.getGroupSize());
            JSONArray jSONArray = new JSONArray();
            for (int j = 0; j < this.viewModel.getGroupSize(); ++j) {
                DFSignPadViewController dFSignPadViewController = this.getSignPadViewController(j);
                DFSignModel dFSignModel = this.viewModel.signModel[j];
                String string = dFSignModel.value;
                boolean bl = true;
                boolean bl2 = false;
                if (dFSignPadViewController != null) {
                    bl2 = dFSignPadViewController.isReusabled != false && !dFSignPadViewController.isValueChangedFlag();
                    bl = !bl2 && !dFSignPadViewController.isValueChangedFlag();
                    string = dFSignPadViewController.signPad != null && dFSignPadViewController.signPad.isSignDrawBitmapMode() ? dFSignModel.value : dFSignPadViewController.getValue();
                }
                jSONArray.put((Object)new JSONObject().put("signdata", (Object)string));
                jSONArray.put((Object)new JSONObject().put("isignore", bl));
                jSONArray.put((Object)new JSONObject().put("isreusable", bl2));
            }
            jSONObject.put("sign_datas", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    public void openAll() {
        int n = 0;
        for (DFSignPadViewController dFSignPadViewController : this.signPadViewList) {
            if (n >= this.viewModel.MAX_SIGN_VIEW) break;
            dFSignPadViewController.show();
            ++n;
        }
    }

    public void updateView() {
        Point point = DFUtils.getScreenSize((Activity)this.getContext());
        boolean bl = point.x < point.y || this.viewModel.isFittoframeVerticalalign();
        DFSignPadViewControllerMaker dFSignPadViewControllerMaker = this.provideControllerMaker();
        for (int j = 0; j < this.viewModel.getSignCount(); ++j) {
            DFSignPadViewControllerMaker$ControllerMakeSpec dFSignPadViewControllerMaker$ControllerMakeSpec = new DFSignPadViewControllerMaker$ControllerMakeSpec();
            dFSignPadViewControllerMaker$ControllerMakeSpec.id = j;
            dFSignPadViewControllerMaker$ControllerMakeSpec.width = this.signWidth;
            dFSignPadViewControllerMaker$ControllerMakeSpec.height = this.signHeight;
            dFSignPadViewControllerMaker$ControllerMakeSpec.context = this.getContext();
            dFSignPadViewControllerMaker$ControllerMakeSpec.globalSetting = this.viewModel;
            dFSignPadViewControllerMaker$ControllerMakeSpec.baseSetting = this.viewModel.signModel[0];
            dFSignPadViewControllerMaker$ControllerMakeSpec.setting = this.viewModel.signModel[j];
            DFSignPadViewController dFSignPadViewController = (DFSignPadViewController)this.signPadViewList.get(j);
            if (!this.viewModel.isAutoReusable()) {
                if (dFSignPadViewControllerMaker$ControllerMakeSpec.setting.value != null && !dFSignPadViewControllerMaker$ControllerMakeSpec.setting.value.isEmpty()) {
                    dFSignPadViewController.show();
                    dFSignPadViewController.setEditable(false);
                } else {
                    dFSignPadViewController.clearValue();
                    dFSignPadViewController.hide();
                    dFSignPadViewController.setEditable(true);
                    dFSignPadViewController.clearValueChangedFlag();
                }
            }
            this.onSignPadSizeChanged();
        }
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777211: {
                object2 = this.getViewValue();
                break;
            }
            case -16777208: {
                String string = (String)object;
                this.viewModel.setAttribute(string);
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.isEndInput;
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case 12: {
                this.executeEvent(12, null);
                break;
            }
            case 13: {
                this.executeEvent(13, null);
                break;
            }
            case -16777214: {
                this.openAll();
                break;
            }
            case -16777213: {
                for (int j = 0; j < this.signPadViewList.size(); ++j) {
                    DFSignPadViewController dFSignPadViewController = (DFSignPadViewController)this.signPadViewList.get(j);
                    dFSignPadViewController.setEditable(false);
                }
                break;
            }
        }
        return object2;
    }

    static /* synthetic */ void access$000(DFSignView dFSignView, int n, Object object) {
        dFSignView.executeEvent(n, object);
    }

    static /* synthetic */ ArrayList access$100(DFSignView dFSignView) {
        return dFSignView.signPadViewList;
    }

    static /* synthetic */ void access$200(DFSignView dFSignView, int n, Object object) {
        dFSignView.executeEvent(n, object);
    }

    static /* synthetic */ void access$300(DFSignView dFSignView, int n, Object object) {
        dFSignView.executeEvent(n, object);
    }

    static /* synthetic */ void access$400(DFSignView dFSignView, int n, Object object) {
        dFSignView.executeEvent(n, object);
    }

    static /* synthetic */ void access$500(DFSignView dFSignView, int n, Object object) {
        dFSignView.executeEvent(n, object);
    }

    static /* synthetic */ void access$600(DFSignView dFSignView, int n, Object object) {
        dFSignView.executeEvent(n, object);
    }
}

