/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.text;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.clearbutton.DFClearButton$Builder;
import oz.viewer.ui.df.mvvm.views.text.DFMultiLineDrawable;
import oz.viewer.ui.df.mvvm.views.text.DFSingleLineDrawable;
import oz.viewer.ui.df.mvvm.views.text.DFTextView$1;
import oz.viewer.ui.df.mvvm.views.text.DFTextView$2;
import oz.viewer.ui.df.mvvm.views.text.DFTextViewModel;
import oz.viewer.ui.df.view.DFLayoutView;

public class DFTextView
extends DFLayoutView
implements TextWatcher,
View.OnClickListener,
View.OnFocusChangeListener,
TextView.OnEditorActionListener {
    private static final int DP_RECT_WIDTH = 2;
    private boolean mTextWatcher;
    protected EditText mEditText;
    private Button mResetButton;
    private TextWatcher mWatcher;
    private View.OnClickListener mOnClickListener;
    private TextView.OnEditorActionListener mOnEditorActionListener;
    private View.OnFocusChangeListener mOnFocusChangeListener;
    public DFTextViewModel viewModel;
    protected FrameLayout mRoot;
    private boolean isChangeAttribute = false;
    private float defaultFontSize = 0.0f;
    private ViewTreeObserver.OnGlobalLayoutListener gListener = new DFTextView$1(this);
    private InputFilter dot_move_filter = null;

    public DFTextView(Context context, DFTextViewModel dFTextViewModel, TextWatcher textWatcher, View.OnClickListener onClickListener, TextView.OnEditorActionListener onEditorActionListener, View.OnFocusChangeListener onFocusChangeListener) {
        super(context);
        this.viewModel = dFTextViewModel;
        this.mWatcher = textWatcher;
        this.mOnClickListener = onClickListener;
        this.mOnEditorActionListener = onEditorActionListener;
        this.mOnFocusChangeListener = onFocusChangeListener;
        this.initView();
    }

    private void initView() {
        this.mRoot = new FrameLayout(this.getContext());
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        linearLayout.setGravity(16);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.setFocusable(true);
        frameLayout.setFocusableInTouchMode(true);
        this.mEditText = new EditText(this.getContext());
        this.mEditText.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.mEditText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEditText.addTextChangedListener((TextWatcher)this);
        this.mEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.defaultFontSize = this.mEditText.getTextSize();
        int n = DFUtils.toDP(this.getContext(), 10.0f);
        int n2 = this.mEditText.getPaddingTop();
        int n3 = DFUtils.toDP(this.getContext(), 32.0f);
        int n4 = this.mEditText.getPaddingBottom();
        this.mEditText.setPadding(0, n2, n3, n4);
        this.mResetButton = new DFClearButton$Builder((ViewGroup)frameLayout).setOnClickListener(this).setSizeDP(22).setLayoutMarginRightDP(10).setLayoutGravity(21).create();
        this.setShowResetButton(false);
        frameLayout.addView((View)this.mEditText);
        frameLayout.addView((View)this.mResetButton);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        linearLayout.addView((View)frameLayout);
        this.mRoot.addView((View)linearLayout);
        this.addView((View)this.mRoot);
        this.setFilters(this.mEditText);
        this.setPaddingContents();
        this.updateView();
    }

    public static void setCursorDrawableColor(EditText editText, int n) {
        if (Build.VERSION.SDK_INT >= 29) {
            ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RectShape());
            shapeDrawable.setIntrinsicWidth(2);
            shapeDrawable.getPaint().setColor(n);
            try {
                Method method = editText.getClass().getMethod("setTextCursorDrawable", Drawable.class);
                method.invoke((Object)editText, shapeDrawable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                Field field = TextView.class.getDeclaredField("mCursorDrawableRes");
                field.setAccessible(true);
                int n2 = field.getInt(editText);
                Field field2 = TextView.class.getDeclaredField("mEditor");
                field2.setAccessible(true);
                Object object = field2.get(editText);
                Class<?> clazz = object.getClass();
                Resources resources = editText.getContext().getResources();
                if (Build.VERSION.SDK_INT >= 28) {
                    Field field3 = clazz.getDeclaredField("mDrawableForCursor");
                    field3.setAccessible(true);
                    Drawable drawable2 = resources.getDrawable(n2);
                    drawable2.setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    field3.set(object, drawable2);
                } else {
                    Field field4 = clazz.getDeclaredField("mCursorDrawable");
                    field4.setAccessible(true);
                    Drawable[] drawableArray = new Drawable[]{resources.getDrawable(n2), resources.getDrawable(n2)};
                    drawableArray[0].setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    drawableArray[1].setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    field4.set(object, drawableArray);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    boolean isNormalType() {
        return this.viewModel.textModel.textInputMode == 1;
    }

    boolean isNumericKeyboard() {
        return this.isNormalType() && this.viewModel.textModel.keyboardType == 2;
    }

    private void updateReturnKeyType() {
        int n = Build.VERSION.SDK_INT > 10 ? 0x2000000 : 0x10000000;
        switch (this.viewModel.getReturnKeyType()) {
            case 4: {
                n |= 5;
                break;
            }
            case 2: {
                n |= 2;
                break;
            }
            case 5: {
                n |= 3;
                break;
            }
            case 6: {
                n |= 4;
                break;
            }
            default: {
                n |= 6;
            }
        }
        this.mEditText.setImeOptions(n);
    }

    private boolean hasFilter() {
        return this.viewModel.textModel.maxLength > 0 || this.isNumericKeyboard();
    }

    public void setFilters(EditText editText) {
        if (this.hasFilter()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.viewModel.textModel.maxLength > 0) {
                if (editText.length() <= this.viewModel.textModel.maxLength) {
                    arrayList.add(new InputFilter.LengthFilter(this.viewModel.textModel.maxLength));
                } else {
                    arrayList.add(new InputFilter.LengthFilter(editText.length()));
                }
            }
            if (this.isNumericKeyboard()) {
                if (this.dot_move_filter == null) {
                    this.dot_move_filter = new DFTextView$2(this, editText);
                }
                arrayList.add(this.dot_move_filter);
            }
            if (arrayList != null) {
                InputFilter[] inputFilterArray = new InputFilter[arrayList.size()];
                arrayList.toArray(inputFilterArray);
                editText.setFilters(inputFilterArray);
            }
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.isChangeAttribute) {
            return;
        }
        this.mWatcher.beforeTextChanged(charSequence, n, n2, n3);
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.isChangeAttribute) {
            return;
        }
        this.setFilters(this.mEditText);
        this.mWatcher.onTextChanged(charSequence, n, n2, n3);
    }

    public void afterSpeaking(String string) {
        this.afterTextChanged(string);
        if (!this.viewModel.textModel.hasTextFilter) {
            this.mTextWatcher = true;
            this.mEditText.setText((CharSequence)string);
            this.mTextWatcher = false;
        }
        this.mEditText.setSelection(this.mEditText.getText().length());
    }

    public void editTextUpdate(String string, int n) {
        if (this.mEditText != null && this.mTextWatcher) {
            int n2 = 0;
            if (string != null) {
                n2 = string.length();
            }
            this.mEditText.setText((CharSequence)string);
            this.mEditText.setSelection(Math.min(n2, n));
            this.requestOnValueChanged(string);
            this.viewModel.value = string;
            this.mTextWatcher = false;
            this.setShowResetButton(string != null && !string.equals(""));
        }
    }

    public void requestOnValueChanged(String string) {
        if (!this.viewModel.textModel.isEndInput && !this.viewModel.value.equals(string)) {
            this.executeEvent(14, string);
        }
    }

    public void afterTextChanged(Editable editable) {
        if (this.isChangeAttribute) {
            return;
        }
        this.mWatcher.afterTextChanged(editable);
        this.afterTextChanged(editable.toString());
    }

    public void afterTextChanged(String string) {
        if (this.isChangeAttribute) {
            return;
        }
        if (this.viewModel.value.equals(string)) {
            return;
        }
        if (!this.mTextWatcher && this.mEventListener != null && this.viewModel.textModel.hasTextFilter) {
            this.mTextWatcher = true;
            boolean bl = false;
            if (this.viewModel.value.length() > string.length()) {
                bl = true;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string);
            arrayList.add(this.mEditText.getSelectionStart());
            arrayList.add(bl);
            arrayList.add(this.viewModel.value);
            this.executeEvent(4, arrayList);
        } else {
            this.requestOnValueChanged(string);
            this.viewModel.value = string;
            this.setShowResetButton(string != null && !string.equals(""));
        }
    }

    public void setShowResetButton(boolean bl) {
        if (bl) {
            this.mResetButton.setVisibility(0);
        } else {
            this.mResetButton.setVisibility(4);
        }
    }

    public void onClick(View view) {
        if (view == this.mResetButton) {
            this.mEditText.setText((CharSequence)"");
        }
        this.mOnClickListener.onClick(view);
    }

    public void performFocusChange(View view, boolean bl) {
        this.onFocusChange(view, bl);
    }

    public void onFocusChange(View view, boolean bl) {
        if (this.isChangeAttribute) {
            return;
        }
        this.mOnFocusChangeListener.onFocusChange(view, bl);
        if (DFUtils.isMobile(this.getContext())) {
            Point point = DFUtils.getScreenSize((Activity)this.getContext());
            this.executeEvent(10, Float.valueOf(this.getY() - (float)(point.y / 3)));
        }
        if (bl) {
            this.executeEvent(12, null);
        }
    }

    private void changeBorderStyle(boolean bl) {
        int n;
        int n2;
        int n3 = this.viewModel.textModel.backgroundColor;
        if (bl) {
            n2 = this.viewModel.textModel.focusBorderColor;
            n = DFUtils.toDP(this.getContext(), this.viewModel.textModel.focusBorderThick > 0 ? (float)this.viewModel.textModel.focusBorderThick : 1.0f);
        } else {
            n2 = this.viewModel.textModel.borderColor;
            n = DFUtils.toDP(this.getContext(), 1.0f);
        }
        if (this.viewModel.textModel.isMultiLine) {
            this.mEditText.setBackground((Drawable)new DFMultiLineDrawable(n3, n2, n));
        } else {
            this.mEditText.setBackground((Drawable)new DFSingleLineDrawable(n3, n2, n, true));
        }
    }

    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
        if (!this.viewModel.textModel.isMultiLine) {
            this.executeEvent(7, null);
        }
        return this.mOnEditorActionListener.onEditorAction(textView, n, keyEvent);
    }

    protected Object OnScript(int n, Object object) {
        Object object2 = null;
        switch (n) {
            case -16777208: {
                String string = (String)object;
                this.viewModel.textModel.setAttribute(string);
                break;
            }
            case -16777209: {
                object2 = this.viewModel.formid;
                break;
            }
            case -16777206: {
                object2 = this.viewModel.textModel.isEndInput;
                break;
            }
            case -16777207: {
                int n2 = (Integer)object;
                if (n2 != 1) break;
                this.updateView();
                break;
            }
            case -16777214: {
                this.executeEvent(5, this.mEditText);
                break;
            }
            case -16777213: {
                this.executeEvent(6, this.mEditText);
                break;
            }
            case 12: {
                this.executeEvent(12, null);
                break;
            }
            case 13: {
                this.executeEvent(13, null);
                break;
            }
            case -16777212: {
                this.mEditText.clearFocus();
                break;
            }
            case -16777211: {
                object2 = this.viewModel.value;
                break;
            }
            case -16777210: {
                if (object == null) {
                    object = "";
                }
                String string = object.toString();
                this.afterSpeaking(string);
                break;
            }
            case -16777215: {
                Object[] objectArray = (Object[])object;
                this.editTextUpdate((String)objectArray[0], (Integer)objectArray[1]);
                break;
            }
            case 8: {
                this.executeEvent(8, null);
            }
        }
        return object2;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void updateView() {
        if (!this.isChangeAttribute) {
            this.isChangeAttribute = true;
            int n = this.viewModel.textModel.fontColor;
            int n2 = this.viewModel.textModel.hintColor;
            int n3 = this.viewModel.textModel.backgroundColor;
            this.mEditText.setTextColor(n);
            int n4 = DFUtils.getFontSizeKey(this.getContext(), this.viewModel.textModel.fontSizeNormal, this.viewModel.textModel.fontSizeSmall);
            if (this.defaultFontSize < (float)n4) {
                this.mEditText.setTextSize((float)n4);
            }
            DFTextView.setCursorDrawableColor(this.mEditText, n);
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setShape(0);
            gradientDrawable.setStroke(DFUtils.toDP(this.getContext(), 2.0f), -1);
            gradientDrawable.setColor(n3);
            this.mEditText.setBackground((Drawable)gradientDrawable);
            this.mEditText.setMinimumHeight(100);
            this.updateReturnKeyType();
            int n5 = this.viewModel.getRealKeyboardType();
            if (this.viewModel.textModel.isMultiLine) {
                this.mEditText.setSingleLine(false);
                this.mEditText.setLines(3);
                this.mEditText.setMinimumHeight(300);
                n5 |= 0x20001;
            }
            this.changeBorderStyle(this.hasHighlight);
            if (this.viewModel.textModel.isShowPassword) {
                this.mEditText.setInputType(this.viewModel.getRealKeyboardTypePassword());
                this.mEditText.setSingleLine();
                this.mEditText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            } else {
                this.mEditText.setInputType(n5);
            }
            this.mEditText.setHint((CharSequence)this.viewModel.textModel.placeholder);
            this.mEditText.setHintTextColor(n2);
            this.mEditText.getViewTreeObserver().addOnGlobalLayoutListener(this.gListener);
            if (this.viewModel.value != null && this.viewModel.value.length() > 0) {
                this.mEditText.setText((CharSequence)this.viewModel.value);
                this.mEditText.setSelection(this.mEditText.getText().length());
                this.setShowResetButton(true);
            }
            this.isChangeAttribute = false;
        }
    }
}

