/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.mvvm.views.voice;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Base64;
import org.json.JSONObject;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.model.voice.DFVoiceModel;

public class DFVoiceViewModel {
    public DFVoiceModel voiceModel;
    public String m_mimeType = "audio/mp4a-latm";
    public String formid;
    public byte[] value = null;
    Context context;

    public DFVoiceViewModel(DFVoiceModel dFVoiceModel) {
        this.voiceModel = dFVoiceModel;
    }

    public DFVoiceViewModel(Context context) {
        this.voiceModel = new DFVoiceModel();
        this.context = context;
    }

    public void setDecodeValue(String string) {
        this.value = this.Base64Decode(string);
    }

    public String Base64Encode(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return "data:" + this.m_mimeType + ";base64," + Base64.encodeToString((byte[])byArray, (int)2);
    }

    public byte[] Base64Decode(String string) {
        if (string != null && !"".equals(string)) {
            if (string.startsWith("data:")) {
                int n = string.indexOf(";base64,");
                if (n > 0) {
                    this.m_mimeType = string.substring("data:".length(), n);
                    return Base64.decode((String)string.substring(n + ";base64,".length()), (int)2);
                }
            } else {
                return Base64.decode((String)string, (int)2);
            }
        }
        return null;
    }

    public void setAttribute(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.setAttribute(jSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAttribute(JSONObject jSONObject) {
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        this.formid = jSONObject.optString("formid");
        this.setDecodeValue(jSONObject.optString("voice_value"));
        this.voiceModel.setAttribute(jSONObject);
        this.voiceModel.fontSize = (Integer)DFStyleManager.getInstance().getStyle(DFUtils.getFontSizeKey(this.context, DFStyleManager.IC_VOICERECORDER_FONT_SIZE_NORMAL, DFStyleManager.IC_VOICERECORDER_FONT_SIZE_SMALL));
        Drawable drawable2 = DFUtils.getMakeFitBitmalDrawable(this.context, 12, DFStyleManager.IC_VOICERECORDER_IS_USE_RECORD_COLOR, DFStyleManager.IC_VOICERECORDER_RECORD_COLOR, DFStyleManager.IC_VOICERECORDER_RECORD_IMAGE, 0.4f);
        this.voiceModel.recordDrawable = DFUtils.createVoiceButtonDrawable(this.context, drawable2, this.voiceModel.borderColor);
        drawable2 = DFUtils.getMakeFitBitmalDrawable(this.context, 14, DFStyleManager.IC_VOICERECORDER_IS_USE_PLAY_COLOR, DFStyleManager.IC_VOICERECORDER_PLAY_COLOR, DFStyleManager.IC_VOICERECORDER_PLAY_IMAGE, 0.4f);
        this.voiceModel.playDrawable = DFUtils.createVoiceButtonDrawable(this.context, drawable2, this.voiceModel.borderColor);
        drawable2 = DFUtils.getMakeFitBitmalDrawable(this.context, 15, DFStyleManager.IC_VOICERECORDER_IS_USE_PAUSE_COLOR, DFStyleManager.IC_VOICERECORDER_PAUSE_COLOR, DFStyleManager.IC_VOICERECORDER_PAUSE_IMAGE, 0.4f);
        this.voiceModel.pauseDrawable = DFUtils.createVoiceButtonDrawable(this.context, drawable2, this.voiceModel.borderColor);
        drawable2 = DFUtils.getMakeFitBitmalDrawable(this.context, 13, DFStyleManager.IC_VOICERECORDER_IS_USE_STOP_COLOR, DFStyleManager.IC_VOICERECORDER_STOP_COLOR, DFStyleManager.IC_VOICERECORDER_STOP_IMAGE, 0.4f);
        this.voiceModel.stopDrawable = DFUtils.createVoiceButtonDrawable(this.context, drawable2, this.voiceModel.borderColor);
        drawable2 = DFUtils.getMakeFitBitmalDrawable(this.context, 17, DFStyleManager.IC_VOICERECORDER_IS_USE_CLEAR_COLOR, DFStyleManager.IC_VOICERECORDER_CLEAR_COLOR, DFStyleManager.IC_VOICERECORDER_CLEAR_IMAGE, 0.4f);
        this.voiceModel.clearDrawable = DFUtils.createVoiceButtonDrawable(this.context, drawable2, this.voiceModel.borderColor);
    }
}

