/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.Button;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;

public class DFClearButton
extends Button {
    public DFClearButton(Context context) {
        super(context);
        DFStyleManager dFStyleManager = DFStyleManager.getInstance();
        String string = (String)dFStyleManager.getStyle(DFStyleManager.IC_CLEAR_BUTTON_IMAGE);
        BitmapDrawable bitmapDrawable = null;
        try {
            if (string.toLowerCase().startsWith("res://")) {
                bitmapDrawable = new BitmapDrawable(null, BitmapFactory.decodeStream((InputStream)this.getContext().getAssets().open(string.substring(6))));
                this.setBackground((Drawable)bitmapDrawable);
                this.setGravity(17);
            } else if (string.toLowerCase().startsWith("http://") || string.toLowerCase().startsWith("https://")) {
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                InputStream inputStream = httpURLConnection.getInputStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                BitmapDrawable bitmapDrawable2 = new BitmapDrawable(null, bitmap);
                this.setBackground((Drawable)bitmapDrawable2);
                this.setGravity(17);
            } else {
                this.setBackground(DFUtils.getImageDrawable(context, 23));
                this.setGravity(17);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setBackground(DFUtils.getImageDrawable(context, 23));
            this.setGravity(17);
        }
    }
}

