/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.widget.LinearLayout;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.mvvm.views.label.DFContentLabelView;

public class DFContentLayout
extends LinearLayout {
    public int _guideX;
    public int _guideY;
    public int _guideX2;
    public int _guideY2;
    public int _guideType;
    public int _guideBorderThick;
    public int _guideBorderColor;
    public int _guideBackgroundColor;
    boolean isDraw = true;

    public DFContentLayout(Context context) {
        super(context);
        this.setWillNotDraw(false);
        this._guideType = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.GUIDE_HIGHLIGHT_TYPE);
        this._guideBorderThick = (Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.GUIDE_HIGHLIGHT_BORDER_THICK);
        this._guideBorderColor = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.GUIDE_HIGHLIGHT_BORDER_COLOR));
        this._guideBackgroundColor = DFUtils.getARGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.GUIDE_HIGHLIGHT_BACKGROUND_COLOR));
    }

    public void setHighlight(int n, int n2, int n3, int n4) {
        this._guideX = n;
        this._guideY = n2;
        this._guideX2 = n3;
        this._guideY2 = n4;
        this.isDraw = true;
        this.postInvalidate();
    }

    public void removeHighlight() {
        this.isDraw = false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isDraw) {
            return;
        }
        if (this._guideX2 <= 0 || this._guideY2 <= 0) {
            return;
        }
        this.drawGuideBackGround(canvas);
        this.drawGuideBorder(canvas);
    }

    private void drawGuideBackGround(Canvas canvas) {
        if (this._guideType == DFContentLabelView.HIGHLIGHT_TYPE_BACKGROUNDCOLOR) {
            Rect rect = new Rect(this._guideX - 1, this._guideY, this._guideX2, this._guideY2);
            Paint paint = new Paint();
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(this._guideBackgroundColor);
            canvas.drawRect(rect, paint);
        }
    }

    private void drawGuideBorder(Canvas canvas) {
        if (this._guideType == DFContentLabelView.HIGHLIGHT_TYPE_BORDER) {
            int n = DFUtils.toDP(this.getContext(), this._guideBorderThick);
            int n2 = DFUtils.toDP(this.getContext(), 10.0f) + n / 2;
            Rect rect = new Rect(this._guideX + n2, this._guideY + n / 2, canvas.getWidth() - n2, this._guideY2 - n / 2);
            Paint paint = new Paint();
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(this._guideBorderColor);
            paint.setStrokeWidth((float)n);
            canvas.drawRect(rect, paint);
        }
    }
}

