/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import oz.viewer.ui.df.DFStyleManager;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFLayoutHelper$PROGRESSBAR_POSITION;

public class DFProgressbar
extends LinearLayout {
    private static final int DP_PADDING_LR = 19;
    private static final int DP_PROGRESS_RAD = 5;
    private static final int DP_PROGRESS_HEIGHT = 4;
    private ProgressBar mProgressbar;
    private DFLayoutHelper$PROGRESSBAR_POSITION mPosition;

    public DFProgressbar(Context context, DFLayoutHelper$PROGRESSBAR_POSITION dFLayoutHelper$PROGRESSBAR_POSITION) {
        super(context);
        this.mPosition = dFLayoutHelper$PROGRESSBAR_POSITION;
        this.init();
    }

    private void init() {
        this.setGravity(21);
        this.setOrientation(1);
        int n = DFUtils.toDP(this.getContext(), 19.0f);
        this.setPadding(n, 0, n, 0);
        this.initProgessbar();
    }

    private void initProgessbar() {
        Context context = this.getContext();
        this.mProgressbar = new ProgressBar(context, null, 16973855);
        this.mProgressbar.setProgressDrawable(this.createProgressDrawable());
        this.mProgressbar.setIndeterminate(false);
        this.addView((View)this.mProgressbar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, DFUtils.toDP(context, 4.0f)));
    }

    private Drawable createProgressDrawable() {
        Drawable drawable2 = this.createShapeDrawable(false);
        ScaleDrawable scaleDrawable = new ScaleDrawable(this.createShapeDrawable(true), 3, 1.0f, -1.0f);
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{drawable2, scaleDrawable, scaleDrawable});
        layerDrawable.setId(0, 0x1020000);
        layerDrawable.setId(1, 16908303);
        layerDrawable.setId(2, 16908301);
        return layerDrawable;
    }

    private Drawable createShapeDrawable(boolean bl) {
        ShapeDrawable shapeDrawable;
        if (this.mPosition == DFLayoutHelper$PROGRESSBAR_POSITION.TOP) {
            shapeDrawable = new ShapeDrawable();
        } else {
            float f2 = DFUtils.toDP_F(this.getContext(), 5.0f);
            RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
            shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        }
        int n = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBAR_TRACK_COLOR));
        int n2 = DFUtils.getRGB((Integer)DFStyleManager.getInstance().getStyle(DFStyleManager.PROGRESSBAR_PROGRESS_COLOR));
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(bl ? n2 : n);
        return shapeDrawable;
    }

    private boolean setProgressInternal(int n) {
        if (this.mProgressbar.getProgress() != n) {
            this.mProgressbar.setProgress(n);
            return true;
        }
        return false;
    }

    public void setProgress(int n) {
        this.setProgressInternal(n);
    }

    private boolean setMaxInternal(int n) {
        if (this.mProgressbar.getMax() != n) {
            this.mProgressbar.setMax(n);
            return true;
        }
        return false;
    }

    public void setMax(int n) {
        this.setMaxInternal(n);
    }

    public void setProgressAndMax(int n, int n2) {
        this.setProgressInternal(n);
        this.setMaxInternal(n2);
    }
}

