/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import oz.main.OZPageView;
import oz.viewer.ui.main.overlay.ATableManager$1;
import oz.viewer.ui.main.overlay.ATableView;
import oz.viewer.ui.main.overlay.ATableView$AThumbnailInfo;
import oz.viewer.ui.main.overlay.ATableView$ThumbnailView;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.SidebarStyle;
import oz.viewer.ui.main.overlay.SidebarStyleManager;

public class ATableManager
extends AutoHideAbleOZOverlayView {
    public static final int TREEMODE = 1;
    public static final int THUMBNAILMODE = 2;
    public static final int NOTHINGMODE = 3;
    public static int DEFAULT_SECTION_FONT_SIZE = 16;
    private int mMode = 3;
    private boolean mIsAutoHideTree;
    private boolean mIsAutoHideThumbnail;
    private boolean mIsCloseTreeAtAutoHide;
    private ATableView mView = new ATableView(this.getContext());
    private SidebarStyleManager mStyleManager;
    private String[] mTreeData;

    public ATableManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 10);
        this.mView.setManager(this);
        this.mView.setVisibility(4);
        this.mStyleManager = new SidebarStyleManager();
    }

    public synchronized void updateSidebarStyle(int n) {
        this.getNativeController().updateSidebarStyle(n);
    }

    public void clearSidebarStyle(int n) {
        if (n >= 0) {
            this.getStyleManager().setStyle(n, null);
        } else {
            this.getStyleManager().setDefaltStyle(new SidebarStyle());
        }
    }

    public void setSidebarStyle(int n, String string, int n2, int n3, int n4, int n5, int n6, String string2, int n7) {
        Typeface typeface;
        SidebarStyle sidebarStyle = new SidebarStyle();
        if (string != null && !string.isEmpty()) {
            typeface = null;
            if (string.startsWith("res://")) {
                typeface = OZPageView.getTypeface("res/" + string.substring("res://".length()), 1);
            } else {
                try {
                    typeface = Typeface.createFromFile((String)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (typeface != null) {
                sidebarStyle.setFont(typeface);
            }
        }
        if (n2 != 0) {
            sidebarStyle.setFont(Typeface.create((Typeface)sidebarStyle.getFont(), (int)n2));
        }
        sidebarStyle.setColor(n4);
        if (n3 <= 0) {
            n3 = DEFAULT_SECTION_FONT_SIZE;
        }
        sidebarStyle.setSize(n3);
        sidebarStyle.setBackGroundColor(n5);
        sidebarStyle.setBorderColor(n6);
        if (string2 != null && !string2.isEmpty()) {
            typeface = null;
            if (string2.startsWith("res://")) {
                typeface = OZPageView.getTypeface("res/" + string2.substring("res://".length()), 1);
            } else {
                try {
                    typeface = Typeface.createFromFile((String)string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (typeface != null) {
                sidebarStyle.setPageNumberFont(typeface);
            }
        }
        sidebarStyle.setPageNumberColor(n7);
        if (n >= 0) {
            this.getStyleManager().setStyle(n, sidebarStyle);
        } else {
            this.getStyleManager().setDefaltStyle(sidebarStyle);
        }
    }

    private void setMode(int n) {
        this.mMode = n;
    }

    public void setTreeTitle(String string) {
        this.mView.setHeaderTitle(string);
    }

    public void clearThumbnail() {
        this.mView.updateThumbnail();
        this.mView.initThumbnail();
    }

    public void waitThumbnail() {
        this.mView.getThumbnailTaskManager().waitTask();
    }

    public void updateThumbnail() {
        this.mView.updateThumbnail();
    }

    public void updateThumbnail(int n) {
        this.mView.updateThumbnail(n);
    }

    public void setAutoHideTree(boolean bl) {
        this.mIsAutoHideTree = bl;
    }

    public void setAutoHideThumbnail(boolean bl) {
        this.mIsAutoHideThumbnail = bl;
    }

    public void setCloseTreeAtAutoHide(boolean bl) {
        this.mIsCloseTreeAtAutoHide = bl;
    }

    public void setTreeData(String string, int n, int n2) {
        if (this.mTreeData == null || this.mTreeData.length != n2) {
            this.mTreeData = new String[n2];
        }
        this.mTreeData[n] = string;
    }

    public void selectThumbnailPage(int n) {
        this.mView.postDelayed(new ATableManager$1(this, n), 200L);
    }

    public void updateThumbnailBitmap() {
        this.mView.updateThumbnail();
    }

    public void setTreeMode() {
        this.mView.setTreeMode(this.mTreeData);
        this.mTreeData = null;
        this.setMode(1);
    }

    public void setThumbnailInfo(int n, boolean bl, String string, int n2, boolean bl2) {
        ATableView$AThumbnailInfo aTableView$AThumbnailInfo = new ATableView$AThumbnailInfo();
        aTableView$AThumbnailInfo.docIndex = n;
        aTableView$AThumbnailInfo.isShowDisplayName = bl;
        aTableView$AThumbnailInfo.displayName = string;
        aTableView$AThumbnailInfo.pageCount = n2;
        aTableView$AThumbnailInfo.hasCloseBtn = bl2;
        this.mView.setThumbnailInfo(aTableView$AThumbnailInfo);
    }

    public void setThumbnailMode(boolean bl) {
        this.mView.setThumbnailMode(bl);
        if (bl) {
            this.setMode(2);
        }
    }

    public void setNothingMode() {
        this.mView.setEmptyMode();
        this.setMode(3);
    }

    public boolean isTreeMode() {
        return this.getMode() == 1;
    }

    public boolean isThumbnailMode() {
        return this.getMode() == 2;
    }

    public boolean isNothingMode() {
        return !this.isTreeMode() && !this.isThumbnailMode();
    }

    public int getMode() {
        return this.mMode;
    }

    public ATableView$ThumbnailView getThumbnailView(int n) {
        return this.mView.getThumbnailTaskManager().getThumbnailView(n);
    }

    public ATableView$ThumbnailView createThumbnailView(int n) {
        return this.mView.getThumbnailTaskManager().createThumbnailView(n);
    }

    public ATableView$ThumbnailView createOrGetThumbnailView(int n) {
        ATableView$ThumbnailView aTableView$ThumbnailView = this.getThumbnailView(n);
        if (aTableView$ThumbnailView == null) {
            aTableView$ThumbnailView = this.createThumbnailView(n);
        }
        return aTableView$ThumbnailView;
    }

    public void setTableWidth(int n) {
        this.mView.setRealWidth(n);
    }

    public boolean IsTableVisible() {
        return this.mView.getTableViewVisble();
    }

    public void openTable() {
        this.mView.openTable();
    }

    public void closeTable() {
        this.mView.closeTable();
    }

    public SidebarStyleManager getStyleManager() {
        return this.mStyleManager;
    }

    public void show() {
        super.show();
        this.mView.updateToggleButton();
    }

    public void hide() {
        super.hide();
        this.mView.clearToggleTouch();
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)this.getParent().findLayout(22000);
        frameLayout.addView((View)this.mView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void setAutoHideEnable(boolean bl) {
        this.setAutoHideTree(bl);
        this.setAutoHideThumbnail(bl);
    }

    public boolean isAutoHideEnable() {
        boolean bl = true;
        switch (this.getMode()) {
            default: {
                bl = this.mIsAutoHideTree;
                break;
            }
            case 2: {
                bl = this.mIsAutoHideThumbnail;
            }
        }
        return bl;
    }

    protected void OnHideAnimationEnd() {
        super.OnHideAnimationEnd();
        if (this.mView != null && this.mIsCloseTreeAtAutoHide && !this.isAutoHideCancel()) {
            this.mView.closeTable();
        }
    }

    static /* synthetic */ ATableView access$000(ATableManager aTableManager) {
        return aTableManager.mView;
    }
}

