package jp.agentec.abook.abv.bl.acms.client.json.content;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.adf.util.StringUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class ActionInfoJSON extends AbstractJSON {
	public static final int VIDEO_ACTION = 1;
	public static final int MUSIC_ACTION = 2;
	public static final int LINKURL_ACTION = 3;
	public static final int PREVIEW_ACTION = 4;
	public static final int JUMPPAGE_ACTION = 5;
	public static final int EMAIL_ACTION = 6;
	public static final int TRIGGER_ACTION = 7;
	public static final int BALLOON_ACTION = 8;
	public static final int MEMO_ACTION = 99;
	public static final int VIEW3D_ACTION = 9;
	public static final int CONTENTLINK_ACTION = 10;
	public static final int HTML_ACTION = 11;
	public static final int ENQUETE_ACTION = 12;
	public static final int EXAM_ACTION = 14;
	public static final int QUIZ_ACTION = 15; // TBD
	
	public ActionInfoJSON(JSONObject actionJson) {
		super(actionJson);
	}
	
	/**
	 * VIDEO_ACTION = 1,
	 * MUSIC_ACTION = 2,
	 * LINKURL_ACTION = 3,
	 * PREVIEW_ACTION = 4, 
	 * JUMPPAGE_ACTION = 5, 
	 * EMAIL_ACTION = 6,
	 * TRIGGER_ACTION = 7, 
	 * BALLOON_ACTION = 8, 
	 * MEMO_ACTION = 99,
	 * VIEW3D_ACTION = 9,
	 * CONTENTLINK_ACTION = 10
	 * HTML_ACTION = 11;
	 * ENQUETE_ACTION = 12;
	 * QUIZ_ACTIOON = 13;
	 * @return actionType
	 */
	public int getActionType() {
		return root.getInt("actionType");
	}
	
	public String getVideoFileName() {
		return root.getString("video");
	}
	
	/**
	 * 1:埋め込み動画
	 * その他（無し）:Full画面動画
	 * @return
	 */
	public int getEmbedType() { // null(-1)可
		return JsonUtil.getInt(root, "embed");
	}
	
	public String getMusicFileName() {
		return root.getString("music");
	}
	
	/**
	 * Audioの再生タイプ
	 * @return 0: タッププレイ、１：コンテンツBGM、２：PAGE BGM
	 */
	public int getPlayType() { // null(-1)可
		return JsonUtil.getInt(root, "playType");
	}
	
	public String getLinkUrl() { // null可
		return JsonUtil.getString(root, "linkUrl");
	}

	public String getBrowserType() { // null可
		return JsonUtil.getString(root, "browserType");
	}
	
	/**
	 * Preview用のイメージファイル名のリスト
	 * @return List<String>
	 */
	public List<String> getPreviewImages() {
		List<String> imageList = new ArrayList<String>();
		try {
			JSONArray images = root.getJSONArray("preview");
			for (int i = 0; i < images.length(); i++) {
				imageList.add(images.getString(i));
			}
		} catch (JSONException e) {
		}
		return imageList;
	}
	
	/**
	 * JUMPPAGE_ACTION(5)
	 * @return
	 */
	public int getJumpPage() {
		return JsonUtil.getInt(root, "jumpPage", 1);
	}
	
	/**
	 * EMAIL_ACTION(6)
	 * @return
	 */
	public String getEmailAddress() { // null可
		return JsonUtil.getString(root, "emailAddress");
	}
	
	/**
	 * EMAIL_ACTION(6)
	 * @return
	 */
	public String getEmailSubject() { // null可
		return JsonUtil.getString(root, "emailSubject");
	}
	
	/**
	 * ターゲットのリソースID
	 * @return
	 */
	public long getTargetId() {
		return root.getLong("target");
	}
	
	/**
	 * ターゲットの配列順番Index
	 * @return
	 */
	public int getTargetIndex() {
		return root.getInt("index");
	}
	
	/**
	 * BALLOON_ACTION(8)
	 * @return html
	 */
	public String getContentHTML() { // null可
		return JsonUtil.getString(root, "content");
	}

//	TODO: 未使用（削除要確認）
//	/**
//	 * MEMO_ACTION(99)
//	 * @return
//	 */
//	public String getMemoText() {
//		return JsonUtil.getString(root, "memoText");
//	}
//	
//	/**
//	 * MEMO_ACTION(99)
//	 * @return
//	 */
//	public long getMemoId() {
//		return JsonUtil.getLong(root, "memoId");
//	}
	
	/**
	 * VIEW3D_ACTION(9)
	 * @return
	 */	
	public View3D getView3DInfo() {
		return new View3D(root.getJSONObject("3dview"));
	}
	
	public static class View3D {
		private JSONObject view3DJson;
		private View3D(JSONObject view3DJson) {
			this.view3DJson = view3DJson;
		}

		public View3DImages getImage(int i, int j) {
			String jsonObj = String.format("%1$02d", i) + "-" + String.format("%1$02d", j);
			return new View3DImages(view3DJson.getJSONObject(jsonObj));
		}
	}
	
	public static class View3DImages {
		private JSONObject view3DImagesJson;
		private View3DImages(JSONObject view3DImagesJson) {
			this.view3DImagesJson = view3DImagesJson;
		}

		public String getFileName() {
			return view3DImagesJson.getString("fileName");
		}
	}
	
	/**
	 * CONTENTLINK_ACTION(10)
	 * @return
	 */
	public long getContentId() {
		return root.getLong("contentId");
	}
	
	/**
	 * CONTENTLINK_ACTION(10)
	 * @return
	 */
	public long getPageNo() {
		return JsonUtil.getLong(root, "pageNo", 1);
	}

//	TODO: 未使用（削除確認）
//	/**
//	 * CONTENTLINK_ACTION(10)
//	 * @return
//	 */
//	public String getContentName() {
//		return JsonUtil.getString(root, "contentName");
//	}
//
//	/**
//	 * CONTENTLINK_ACTION(10)
//	 * @return
//	 */
//	public long getContractContentId() {
//		return JsonUtil.getLong(root, "contractContentId");
//	}

//	public String getObjectName() { // null可
//		return JsonUtil.getString(root, "objectName", "");
//	}

//	public String getContentName() {
//		return JsonUtil.getString(root, "contentName");
//	}
//
//	public int getContractContentId() {
//		return root.getInt("contractContentId");
//	}
//
//	public String getContentURL() {
//		return JsonUtil.getString(root, "contentURL");
//	}
//
//	public long getMajor() {
//		return JsonUtil.getLong(root, "major");
//	}
//
//	public long getMinor() {
//		return JsonUtil.getLong(root, "minor");
//	}

	/**
	 * ENQUETE_ACTION(12)
	 * @return
	 */
	public int getReplyLimit() { // -1可
		return JsonUtil.getInt(root, "replyLimit");
	}
	
	public int getSaveAs() { // -1可
		return JsonUtil.getInt(root, "saveAs");
	}
	
	public int getFullScreen() { // -1可
		return JsonUtil.getInt(root, "fullScreen");
	}
	
	public long getEnqueteId() {
		return root.getLong("enqueteId");
	}
	
	public long getObjectId() { // 旧フォーマットではなしなのでデフォルト0に。-1はコンテンツを識別するのに使用しているので0にする。
		return JsonUtil.getLong(root, "objectId", 0);
	}

	public String getEnquete() {
		String fileName = root.getString("enquete"); // 空は不可
		if (fileName.equals("")) {
			throw new JSONException("invalid enquete");
		}
		fileName = fileName.replace(".zip", "");
		return fileName;
	}
	
	public String getQuestionNo() { // デフォルト"0"
		return JsonUtil.getString(root, "questionNo", "0");
	}

	public int getShowResult() {
		return root.getInt("showResult");
	}
	
	public int getSendResult() {
		return root.getInt("sendResult");
	}
	
	/**
	 * HTML_ACTION(11)
	 * @return
	 */
	public String getHtml() {
		String fileName = root.getString("html"); 
		if (StringUtil.isNullOrEmpty(fileName)) {
			throw new JSONException("invalid html");
		}
		fileName = fileName.replace(".zip", "");
		return fileName;
	}
	
	public Long[] getResourceIds() {
		JSONArray resourceIdsArray = JsonUtil.getJSONArray(root, "resourceIds");
		Long[] resourceIds = new Long[resourceIdsArray.length()];
		for (int i = 0; i < resourceIdsArray.length(); i++) {
			resourceIds[i] = resourceIdsArray.getLong(i);
		}
		return resourceIds;
	}
}
