package jp.agentec.abook.abv.bl.acms.client.parameters;

import java.sql.Timestamp;


/**
 * アンケート用のパラメータです。
 * 
 * @author Youngmin Chae
 * @version 1.0.0
 */
public class GetEnqueteReplyParameters extends AcmsParameters {
	private final long contentId;
	private final long abObjectId;
	private final Timestamp replyDateStr;
	private final int devieTypeId;
	
	private String loginId;
	private String key;
	/**
	 * {@link GetEnqueteReplyParameters} のインスタンスを初期化します。
	 * @param sid ログインした時のセッションIDです。
	 * @since 1.0.0
	 */
	public GetEnqueteReplyParameters(String sid, long contentId, long abObjectId, Timestamp replyDateStr, int deviceTypeId) {
		super(sid);
		this.contentId = contentId;
		this.abObjectId = abObjectId;
		this.replyDateStr = replyDateStr;
		this.devieTypeId = deviceTypeId;
	}
	
	public long getContentId() {
		return contentId;
	}
	
	public long getAbObjectId() {
		return abObjectId;
	}
	
	public Timestamp getReplyDateStr() {
		return replyDateStr;
	}
	public int getDeviceTypeId() {
		return devieTypeId;
	}

	public void setLoginId(String loginId) {
		this.loginId = loginId;
	}

	public String getLoginId() {
		return this.loginId;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

}
