package jp.agentec.abook.abv.bl.dto;

import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class MeetingDto {
	public static final int TYPE_PASSWORD = 0;
	public static final int TYPE_OPEN = 2;
	
	public int meetingId;
	public String title;
	public int type;
	public String ownerLoginId;
	public String ownerName;
	public int status;
	public int attendees;
	public String createdate; // UTCでsyncserverから返却
	public String presenterskey;
	public String appversion;
	/**
	 * 空表示用のフラグ、設定データがない場合、このフラグをtrueにしたDtoを作成する
	 */
	public boolean isEmptyView = false;
	
	@Override
	public String toString() {
		return "meetingId=" + meetingId + " title=" + title  + " type=" + type  + " owner=" + ownerLoginId + " status=" + status + " presenterskey=" + presenterskey + " appversion=" + appversion;
	}

	public String getCreateDateInLocalTime() {
		return DateTimeUtil.toString(DateTimeUtil.toDate(createdate, "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen), DateTimeFormat.yyyyMMddHHmmss_hyphen);
	}

}
