package jp.agentec.abook.abv.bl.dto;

import java.util.Date;

import jp.agentec.abook.abv.bl.acms.type.RequirePasswordChangeCode;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.DateTimeUtil.DateUnit;

/**
 * ユーザ情報を格納します。
 * @author Taejin Hong
 * @version　1.0.0
 */
public class MemberInfoDto extends AbstractDto {
	public String loginId;
	public String password;
	public String memberName;
	public String sid;
	public Integer userId; //ABookSee 1.8.1
	public int loginStatus;
	public short invalidPasswordCount;
	public Date lastLoginDate;
	public Date lastChangePasswordDate;
	public Date lastCMSAccessDate;
	public Date passwordExpiryDate;
	public String lastUpdateInfor; //ABookSee 1.8.1
	public String workerCode;
	
	public RequirePasswordChangeCode requiredPasswordChange;
	
	@Override
	public Object[] getInsertValues() {
		return new Object[]{loginId, password, memberName, sid, loginStatus, invalidPasswordCount, lastLoginDate, lastChangePasswordDate, lastCMSAccessDate, userId, lastUpdateInfor, workerCode};
	}

	@Override
	public Object[] getUpdateValues() {
		return new Object[]{password, memberName, sid, loginStatus, invalidPasswordCount, lastLoginDate, lastChangePasswordDate, lastCMSAccessDate, lastUpdateInfor, workerCode, loginId};
	}

	@Override
	public String[] getKeyValues() {
		return new String[]{""+ loginId};
	}

	public void setLastChangePasswordDate(Date lastChangePasswordDate) {
		this.lastChangePasswordDate = lastChangePasswordDate;
	}
}
