package jp.agentec.abook.abv.bl.data.dao;

import java.util.UUID;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.ContentMarkingDto;
import jp.agentec.adf.util.DateTimeUtil;
import junit.framework.TestCase;

public class ContentMarkingDaoTest extends TestCase {

	private ContentMarkingDao dao = AbstractDao.getDao(ContentMarkingDao.class);

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testInsertMarking() throws Exception {
		ContentMarkingDto dto1 = new ContentMarkingDto();
		dto1.contentId = 1;
		dto1.pageNum = 0;
		dto1.markingId = UUID.randomUUID().toString();
		dto1.fileName = "0.png";
		dto1.insertDate = DateTimeUtil.getCurrentDate();
		dto1.updateDate = DateTimeUtil.getCurrentDate();

		dao.insertMarking(dto1);

		ContentMarkingDto dto2 = new ContentMarkingDto();
		dto2.contentId = 1;
		dto2.pageNum = 1;
		dto2.markingId = UUID.randomUUID().toString();
		dto2.fileName = "0.png";
		dto2.insertDate = DateTimeUtil.getCurrentDate();
		dto2.updateDate = DateTimeUtil.getCurrentDate();

		dao.insertMarking(dto2);

		ContentMarkingDto dto1_1 = dao.getMarking(dto1.contentId, dto1.pageNum);
		assertEquals(dto1_1.contentId, dto1.contentId);
		assertEquals(dto1_1.pageNum, dto1.pageNum);
		assertEquals(dto1_1.markingId, dto1.markingId);
		assertEquals(dto1_1.fileName, dto1.fileName);
		assertEquals(dto1_1.insertDate, dto1.insertDate);
		assertEquals(dto1_1.updateDate, dto1.updateDate);

		ContentMarkingDto dto2_1 = dao.getMarking(dto2.contentId, dto2.pageNum);
		assertEquals(dto2_1.contentId, dto2.contentId);
		assertEquals(dto2_1.pageNum, dto2.pageNum);
		assertEquals(dto2_1.markingId, dto2.markingId);
		assertEquals(dto2_1.fileName, dto2.fileName);
		assertEquals(dto2_1.insertDate, dto2.insertDate);
		assertEquals(dto2_1.updateDate, dto2.updateDate);
	}
	
	public void testGetMarkingList() throws Exception {
		for (ContentMarkingDto dto : dao.getMarkingList(1)) {
			System.out.println("contentId:" + dto.contentId);
			System.out.println("pageNum:" + dto.pageNum);
			System.out.println("markingId:" + dto.markingId);
			System.out.println("fileName:" + dto.fileName);
			System.out.println("insertDate:" + dto.insertDate);
			System.out.println("updateDate:" + dto.updateDate);
		}

	}
	
	public void testDeleteMarking() {
		dao.deleteMarking(1);
//		dao.deleteMarking(1,0);
	}
	
	public void testUpdateMarking() {
		ContentMarkingDto dto = dao.getMarking(1, 0);
		dto.markingId = "update";
		dto.fileName = "update";
//		dto.insertDate = DateTimeUtil.getCurrentDate();
		dto.updateDate = DateTimeUtil.getCurrentDate();
		dao.updateMarking(dto);
	}
	
	

}
