package jp.agentec.abook.abv.bl.logic;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.ContentMemoDto;
import jp.agentec.adf.util.DateTimeUtil;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ContentLogicTest extends TestCase {

	private ContentLogic logic = AbstractLogic.getLogic(ContentLogic.class);
	private MemoLogic memoLogic = AbstractLogic.getLogic(MemoLogic.class);

	public ContentLogicTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("ContentLogicTest");
		suite.addTest(new ContentLogicTest("testGetContentListByPublisher"));
		suite.addTest(new ContentLogicTest("testGetSignageAutoDownloadTarget"));
		return suite;
	}

	public void testCopyContentMemo() throws Exception {
		long srcContentId = 1023;
		long dstContentId = 1443;

		ContentMemoDto contentMemoDto = new ContentMemoDto();
		contentMemoDto.contentId = 1;
		contentMemoDto.pageNum = 10;
		contentMemoDto.memo = "contentId:1, pageNum:0";
		contentMemoDto.axisX = 50;
		contentMemoDto.axisY = 50;
		contentMemoDto.copyFlg = false;
		contentMemoDto.delFlg = false;
		contentMemoDto.insertDate = DateTimeUtil.getCurrentSqlDate();
		contentMemoDto.updateDate = DateTimeUtil.getCurrentSqlDate();

		memoLogic.insertContentMemo(contentMemoDto);
		memoLogic.copyContentMemo(srcContentId, dstContentId);
	}
	
	public void testCopyContentBookmark() throws Exception {
		long srcContentId = 1023;
		long dstContentId = 1331;
		AbstractLogic.getLogic(BookmarkLogic.class).copyContentBookmark(srcContentId, dstContentId);
	}

	public void testGetContentListByPublisher() throws NetworkDisconnectedException, Exception {
		for (ContentDto contentDto : logic.getContentListByPublisher(null, 1, 26, null, null, null, null, false, null)) {
			Logger.d("" + contentDto.contentName);
		}
	}
}
