package jp.agentec.abook.abv.ui.common.dialog;

import jp.agentec.abook.abv.launcher.android.R;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

public class ABookAlertDialog extends AlertDialog {

	private View messageView = null;
	public ABookAlertDialog(Context context) {
		super(context, R.style.Theme_MyDialog);
		init();
	}

	public ABookAlertDialog(Context context, boolean cancelable, OnCancelListener cancelListener) {
		super(context, cancelable, cancelListener);
		init();
	}
	
	private void init() {
		setCanceledOnTouchOutside(false);
		
		messageView = LayoutInflater.from(getContext()).inflate(R.layout.alert_dialog_main, null);
		
		DisplayMetrics metrics = getContext().getResources().getDisplayMetrics();
		int dialogWidth;

		if (metrics.widthPixels > metrics.heightPixels) {
			dialogWidth = (int) (metrics.heightPixels * 0.5);
		} else {
			dialogWidth = (int) (metrics.widthPixels * 0.5);
		}
		TextView txtMessage = (TextView) messageView.findViewById(R.id.main_text);
		txtMessage.setMaxWidth(dialogWidth);
	}
	
	public void setNegativeButton(int nameId, DialogInterface.OnClickListener l) {
		String name = getContext().getResources().getString(nameId);
		setButton(DialogInterface.BUTTON_NEGATIVE, name, l);
	}
	
	public void setPositiveButton(int nameId, DialogInterface.OnClickListener l) {
		String name = getContext().getResources().getString(nameId);
		setButton(DialogInterface.BUTTON_POSITIVE, name, l);
	}
	
	public void setNeutralButton(int nameId, DialogInterface.OnClickListener l) {
		String name = getContext().getResources().getString(nameId);
		setButton(DialogInterface.BUTTON_NEUTRAL, name, l);
	}
	
	public void setMessage(int messageId) {
		Resources r = getContext().getResources();
		String message = r.getString(messageId);
		setMessage(message);
	}
	
	public void setMessage(String message) {
		TextView txtMessage = (TextView) messageView.findViewById(R.id.main_text);
		txtMessage.setText(message);
		setView(messageView);
	}
	
	public void setAdapter(ListAdapter adapter, final OnItemClickListener l) {
		ListView listView = new ListView(getContext());
		listView.setAdapter(adapter);
		setView(listView);
		listView.setOnItemClickListener(l);
	}
}
