package jp.agentec.abook.abv.ui.common.util;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.parameters.CheckSendLogParameters;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.cl.helper.ABVUncaughtExceptionHandler;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;

/**
 * Created by jang on 2017/07/07.
 */

public class LogUtil {

    private static final String TAG = "LogUtil";

    /**
     * ExportログをCMS側に送るかどうかのチェックを行う
     */
    public static void checkSendLogFlag() {
        Logger.d(TAG, "[checkSendLogFlag]: start--");
        ABVDataCache dataCache = ABVDataCache.getInstance();
        AcmsClient client = AcmsClient.getInstance(dataCache.getUrlPath(), ABVEnvironment.getInstance().networkAdapter);
        try {
            CheckSendLogParameters parameters;
            if (ABVEnvironment.getInstance().deviceIdType == Constant.DeviceIdType.MAC_ADDRESS) {
                parameters = new CheckSendLogParameters(dataCache.getMemberInfo().sid, ABVEnvironment.DeviceTypeId, null, ABVEnvironment.getInstance().deviceId);
            } else {
                // Android 6以上の場合
                parameters = new CheckSendLogParameters(dataCache.getMemberInfo().sid, ABVEnvironment.DeviceTypeId, ABVEnvironment.getInstance().deviceId, null);
            }
            int status = client.checkSendLogFile(parameters);
            if (status == 1) {
                boolean result = ABVUncaughtExceptionHandler.getInstancer().sendLogFileToAcms(ActivityHandlingHelper.getInstance().getCurrentActivity());
                Logger.i(TAG, "[checkSendLogFlag]: result=" + result);
            }
        } catch (NetworkDisconnectedException e) {
            Logger.d(TAG, "[checkSendLogFlag]: NetworkDisconnectedException");
        } catch (AcmsException e) {
            Logger.e(TAG, "[checkSendLogFlag]: " + e.getMessage(), e);
        }
    }
}
