package jp.agentec.abook.abv.ui.common.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.ImageButton;

public class ABVImageLineButton extends ImageButton {
	private boolean mSelectFlg = false;
	
	public ABVImageLineButton(Context context) {
		super(context);
	}
	public ABVImageLineButton(Context context, AttributeSet attrs) {
		super(context, attrs);
	}
	
	@Override
	protected void onDraw(Canvas canvas) {
		Paint paint = new Paint();
		paint.setColor(Color.BLACK);
		if (mSelectFlg == true) {
			canvas.drawLine(0, 0, getWidth(), 0, paint);
			canvas.drawLine(0, 0, 0, getHeight(), paint);
			canvas.drawLine(getWidth(), 0, getWidth(), getHeight(), paint);
			canvas.drawLine(0, getHeight(), getWidth(), getHeight(), paint);
		} else {
			canvas.drawLine(0, 0, getWidth(), 0, paint);
			canvas.drawLine(0, 0, 0, getHeight(), paint);
			canvas.drawLine(getWidth(), 0, getWidth(), getHeight(), paint);
			canvas.drawLine(0, getHeight(), getWidth(), getHeight(), paint);
			
			canvas.drawLine(-5, 0, getWidth(), 0, paint);
			canvas.drawLine(0, 0, 0, getHeight(), paint);
			canvas.drawLine(getWidth(), 0, getWidth(), getHeight(), paint);
			canvas.drawLine(0, getHeight(), getWidth(), getHeight(), paint);
		}
	}
	
	public void setSelect(boolean selectFlg) {
		mSelectFlg = selectFlg;
	}
}
