package jp.agentec.abook.abv.ui.viewer.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.theta.network.ThetaDeviceInfo;

import java.util.List;

import jp.agentec.abook.abv.launcher.android.R;

public class WifiThetaConnectAdapter extends BaseAdapter {
    private List<ThetaDeviceInfo> mListItem;
    private LayoutInflater mInflater;

    public WifiThetaConnectAdapter(Context context, List<ThetaDeviceInfo> listItem) {
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        this.mListItem = listItem;
    }

    public void setListItem(List<ThetaDeviceInfo> listItem) {
        mListItem = listItem;
    }

    @Override
    public int getCount() {
        return mListItem.size();
    }

    @Override
    public Object getItem(int position) {
        return mListItem.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_simple_textview, null);
        }
        TextView textView = convertView.findViewById(R.id.tv_item);
        textView.setTextColor(Color.parseColor("#1C6C9B"));

        ThetaDeviceInfo info = mListItem.get(position);
        textView.setText(info.getSSID());
        return convertView;
    }
}
