package jp.agentec.abook.abv.ui.viewer.view.action;

import java.lang.reflect.Method;

import android.content.Context;
import android.graphics.Paint;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;

/***********************************************************************
 * リッチテキストHTML  クラス
 ***********************************************************************/
public class RichTextHtmlAction {
	//***** リッチテキストHTMLの追加
	public WebView addRichTextHtml(Context context, final int x, final int y, int w, int h, float fscale, String html, final RelativeLayout layout) {
    	RelativeLayout.LayoutParams param1_ = new RelativeLayout.LayoutParams(w, h);
    	param1_.setMargins(x, y, 0, 0);
    	
    	WebView webView = new WebView(context);
//    	webView_.setVerticalScrollbarOverlay(true);       //スクロールバー部分の隙間を消す
    	webView.setVerticalScrollBarEnabled(false); // スクロールバーは今回は禁止
    	webView.setHorizontalScrollBarEnabled(false); // スクロールバーは今回は禁止
        webView.setWebViewClient(new WebViewClient());   //ブラウザの描画領域を対象としたイベントをフック
        webView.setInitialScale((int)(fscale * 80)); // 80%は目視で適当に調節した値
        webView.setBackgroundColor(0);
        if (Build.VERSION.SDK_INT >= 11) {
//        	webView.setLayerType(View.LAYER_TYPE_SOFTWARE, null); // API level 10ではこれではビルドが通らないので以下のリフレクションを使う。
        	try {
        		Method setLayerTypeMethod = webView.getClass().getMethod("setLayerType", int.class, Paint.class);
        		setLayerTypeMethod.invoke(webView, 1, null);
        	} catch (Exception e) { // Older OS, no HW acceleration anyway. ignore
        	}
        }
        
    	webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
    	webView.setOnTouchListener(new OnTouchListener() {
			@Override
			public boolean onTouch(View v, MotionEvent event) { // タッチイベントを下層に伝える
				event.setLocation(x + event.getX(), y + event.getY()); // メモ用に座標を変換する
				layout.onTouchEvent(event);
				return true;
			}
		});
        
        WebSettings settings = webView.getSettings();
        settings.setSupportMultipleWindows(true);        //新しいウィンドウを開くイベントを取得する
        settings.setLoadsImagesAutomatically(true);      //イメージを自動的にロードする
        settings.setSupportZoom(true);                   //ズーム機能を有効にする
		//noinspection deprecation(API18から非推奨になった。無視)
        settings.setLightTouchEnabled(true);             //
        settings.setJavaScriptEnabled(false);             //JavaScriptを無効にする

        layout.addView(webView, param1_);
    	
		return webView;
    }
    
}
