/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility.captioning;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Typeface;
import android.os.Build;
import android.view.accessibility.CaptioningManager;

@TargetApi(value=19)
public class CaptioningStyle {
    private Integer mBackgroundColor;
    private Integer mEdgeColor;
    private Integer mEdgeType;
    private Integer mForegroundColor;
    private Integer mWindowColor;
    private Typeface mTypeface;

    public CaptioningStyle(Integer backgroundColor, Integer edgeColor, Integer edgeType, Integer foregroundColor, Integer windowColor, Typeface typeface) {
        this.mBackgroundColor = backgroundColor;
        this.mEdgeColor = edgeColor;
        this.mEdgeType = edgeType;
        this.mForegroundColor = foregroundColor;
        this.mWindowColor = windowColor;
        this.mTypeface = typeface;
    }

    public Integer getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Integer getEdgeColor() {
        return this.mEdgeColor;
    }

    public Integer getEdgeType() {
        return this.mEdgeType;
    }

    public Integer getForegroundColor() {
        return this.mForegroundColor;
    }

    public Integer getWindowColor() {
        return this.mWindowColor;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    @SuppressLint(value={"NewApi"})
    public static CaptioningStyle createFrom(CaptioningManager.CaptionStyle captionStyle) {
        if (captionStyle == null) {
            return new CaptioningStyle(null, null, null, null, null, null);
        }
        Integer backgroundColor = null;
        Integer edgeColor = null;
        Integer edgeType = null;
        Integer foregroundColor = null;
        Integer windowColor = null;
        if (Build.VERSION.SDK_INT >= 21) {
            if (captionStyle.hasBackgroundColor()) {
                backgroundColor = captionStyle.backgroundColor;
            }
            if (captionStyle.hasEdgeColor()) {
                edgeColor = captionStyle.edgeColor;
            }
            if (captionStyle.hasEdgeType()) {
                edgeType = captionStyle.edgeType;
            }
            if (captionStyle.hasForegroundColor()) {
                foregroundColor = captionStyle.foregroundColor;
            }
            if (captionStyle.hasWindowColor()) {
                windowColor = captionStyle.windowColor;
            }
        } else {
            backgroundColor = captionStyle.backgroundColor;
            edgeColor = captionStyle.edgeColor;
            edgeType = captionStyle.edgeType;
            foregroundColor = captionStyle.foregroundColor;
        }
        return new CaptioningStyle(backgroundColor, edgeColor, edgeType, foregroundColor, windowColor, captionStyle.getTypeface());
    }
}

