/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.input.ChromiumBaseInputConnection;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.ImeUtils;
import org.chromium.content.browser.input.Range;
import org.chromium.content.browser.input.TextInputState;

public class ThreadedInputConnection
extends BaseInputConnection
implements ChromiumBaseInputConnection {
    private static final String TAG = "cr_Ime";
    private static final boolean DEBUG_LOGS = false;
    private static final TextInputState UNBLOCKER = new TextInputState("", new Range(0, 0), new Range(-1, -1), false, false){

        @Override
        public boolean shouldUnblock() {
            return true;
        }
    };
    private final Runnable mProcessPendingInputStatesRunnable = new Runnable(){

        @Override
        public void run() {
            ThreadedInputConnection.this.processPendingInputStates();
        }
    };
    private final Runnable mMoveCursorSelectionEndRunnable = new Runnable(){

        @Override
        public void run() {
            TextInputState textInputState = ThreadedInputConnection.this.requestAndWaitForTextInputState();
            if (textInputState == null) {
                return;
            }
            Range selection = textInputState.selection();
            ThreadedInputConnection.this.setSelection(selection.end(), selection.end());
        }
    };
    private final Runnable mRequestTextInputStateUpdate = new Runnable(){

        @Override
        public void run() {
            boolean result = ThreadedInputConnection.this.mImeAdapter.requestTextInputStateUpdate();
            if (!result) {
                ThreadedInputConnection.this.unblockOnUiThread();
            }
        }
    };
    private final Runnable mNotifyUserActionRunnable = new Runnable(){

        @Override
        public void run() {
            ThreadedInputConnection.this.mImeAdapter.notifyUserAction();
        }
    };
    private final Runnable mFinishComposingTextRunnable = new Runnable(){

        @Override
        public void run() {
            ThreadedInputConnection.this.mImeAdapter.finishComposingText();
        }
    };
    private final ImeAdapter mImeAdapter;
    private final Handler mHandler;
    private int mNumNestedBatchEdits;
    private final BlockingQueue<TextInputState> mQueue = new LinkedBlockingQueue<TextInputState>();
    private int mPendingAccent;

    ThreadedInputConnection(View view, ImeAdapter imeAdapter, Handler handler) {
        super(view, true);
        ImeUtils.checkOnUiThread();
        this.mImeAdapter = imeAdapter;
        this.mHandler = handler;
    }

    void resetOnUiThread() {
        ImeUtils.checkOnUiThread();
        this.mNumNestedBatchEdits = 0;
        this.mPendingAccent = 0;
    }

    @Override
    public void updateStateOnUiThread(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean singleLine, boolean isNonImeChange) {
        ImeUtils.checkOnUiThread();
        TextInputState newState = new TextInputState(text, new Range(selectionStart, selectionEnd), new Range(compositionStart, compositionEnd), singleLine, !isNonImeChange);
        this.addToQueueOnUiThread(newState);
        if (isNonImeChange) {
            this.mHandler.post(this.mProcessPendingInputStatesRunnable);
        }
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public void onRestartInputOnUiThread() {
    }

    @Override
    public boolean sendKeyEventOnUiThread(final KeyEvent event) {
        ImeUtils.checkOnUiThread();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.sendKeyEvent(event);
            }
        });
        return true;
    }

    @Override
    public void moveCursorToSelectionEndOnUiThread() {
        this.mHandler.post(this.mMoveCursorSelectionEndRunnable);
    }

    @Override
    @VisibleForTesting
    public void unblockOnUiThread() {
        ImeUtils.checkOnUiThread();
        this.addToQueueOnUiThread(UNBLOCKER);
        this.mHandler.post(this.mProcessPendingInputStatesRunnable);
    }

    private void processPendingInputStates() {
        this.assertOnImeThread();
        TextInputState state;
        while ((state = (TextInputState)this.mQueue.poll()) != null) {
            if (state.shouldUnblock()) continue;
            this.updateSelection(state);
        }
        return;
    }

    private void updateSelection(TextInputState textInputState) {
        if (textInputState == null) {
            return;
        }
        this.assertOnImeThread();
        if (this.mNumNestedBatchEdits != 0) {
            return;
        }
        Range selection = textInputState.selection();
        Range composition = textInputState.composition();
        this.mImeAdapter.updateSelection(selection.start(), selection.end(), composition.start(), composition.end());
    }

    private TextInputState requestAndWaitForTextInputState() {
        ThreadUtils.postOnUiThread(this.mRequestTextInputStateUpdate);
        return this.blockAndGetStateUpdate();
    }

    private void addToQueueOnUiThread(TextInputState textInputState) {
        ImeUtils.checkOnUiThread();
        try {
            this.mQueue.put(textInputState);
        }
        catch (InterruptedException e) {
            Log.e(TAG, "addToQueueOnUiThread interrupted", e);
        }
    }

    BlockingQueue<TextInputState> getQueueForTest() {
        return this.mQueue;
    }

    private void assertOnImeThread() {
        ImeUtils.checkCondition(this.mHandler.getLooper() == Looper.myLooper());
    }

    private TextInputState blockAndGetStateUpdate() {
        this.assertOnImeThread();
        boolean shouldUpdateSelection = false;
        while (true) {
            TextInputState state;
            try {
                state = this.mQueue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                ImeUtils.checkCondition(false);
                return null;
            }
            if (state.shouldUnblock()) {
                return null;
            }
            if (state.fromIme()) {
                if (shouldUpdateSelection) {
                    this.updateSelection(state);
                }
                return state;
            }
            shouldUpdateSelection = true;
        }
    }

    private void notifyUserAction() {
        ThreadUtils.postOnUiThread(this.mNotifyUserActionRunnable);
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        return this.updateComposingText(text, newCursorPosition, false);
    }

    @VisibleForTesting
    public boolean updateComposingText(final CharSequence text, final int newCursorPosition, boolean isPendingAccent) {
        final int accentToSend = isPendingAccent ? this.mPendingAccent | Integer.MIN_VALUE : 0;
        this.assertOnImeThread();
        this.cancelCombiningAccent();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.sendCompositionToNative(text, newCursorPosition, false, accentToSend);
            }
        });
        this.notifyUserAction();
        return true;
    }

    public boolean commitText(final CharSequence text, final int newCursorPosition) {
        this.assertOnImeThread();
        this.cancelCombiningAccent();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.sendCompositionToNative(text, newCursorPosition, text.length() > 0, 0);
            }
        });
        this.notifyUserAction();
        return true;
    }

    public boolean performEditorAction(final int actionCode) {
        this.assertOnImeThread();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.performEditorAction(actionCode);
            }
        });
        return true;
    }

    public boolean performContextMenuAction(final int id2) {
        this.assertOnImeThread();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.performContextMenuAction(id2);
            }
        });
        return true;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        this.assertOnImeThread();
        TextInputState textInputState = this.requestAndWaitForTextInputState();
        if (textInputState == null) {
            return null;
        }
        ExtractedText extractedText = new ExtractedText();
        extractedText.text = textInputState.text();
        extractedText.partialEndOffset = textInputState.text().length();
        extractedText.selectionStart = textInputState.selection().start();
        extractedText.selectionEnd = textInputState.selection().end();
        extractedText.flags = textInputState.singleLine() ? 1 : 0;
        return extractedText;
    }

    public boolean beginBatchEdit() {
        this.assertOnImeThread();
        ++this.mNumNestedBatchEdits;
        return true;
    }

    public boolean endBatchEdit() {
        this.assertOnImeThread();
        if (this.mNumNestedBatchEdits == 0) {
            return false;
        }
        --this.mNumNestedBatchEdits;
        if (this.mNumNestedBatchEdits == 0) {
            this.updateSelection(this.requestAndWaitForTextInputState());
        }
        return this.mNumNestedBatchEdits != 0;
    }

    public boolean deleteSurroundingText(final int beforeLength, final int afterLength) {
        this.assertOnImeThread();
        if (this.mPendingAccent != 0) {
            this.finishComposingText();
        }
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.deleteSurroundingText(beforeLength, afterLength);
            }
        });
        return true;
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        return false;
    }

    public boolean sendKeyEvent(final KeyEvent event) {
        this.assertOnImeThread();
        if (this.handleCombiningAccent(event)) {
            return true;
        }
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.sendKeyEvent(event);
            }
        });
        this.notifyUserAction();
        return true;
    }

    private boolean handleCombiningAccent(KeyEvent event) {
        int action = event.getAction();
        int unicodeChar = event.getUnicodeChar();
        if (action != 0) {
            return false;
        }
        if ((unicodeChar & Integer.MIN_VALUE) != 0) {
            int pendingAccent = unicodeChar & Integer.MAX_VALUE;
            StringBuilder builder = new StringBuilder();
            builder.appendCodePoint(pendingAccent);
            this.updateComposingText(builder.toString(), 1, true);
            this.setCombiningAccent(pendingAccent);
            return true;
        }
        if (this.mPendingAccent != 0 && unicodeChar != 0) {
            int combined = KeyEvent.getDeadChar((int)this.mPendingAccent, (int)unicodeChar);
            if (combined != 0) {
                StringBuilder builder = new StringBuilder();
                builder.appendCodePoint(combined);
                this.commitText(builder.toString(), 1);
                return true;
            }
            this.finishComposingText();
        }
        return false;
    }

    @VisibleForTesting
    public void setCombiningAccent(int pendingAccent) {
        this.mPendingAccent = pendingAccent;
    }

    private void cancelCombiningAccent() {
        this.mPendingAccent = 0;
    }

    public boolean finishComposingText() {
        this.cancelCombiningAccent();
        ThreadUtils.postOnUiThread(this.mFinishComposingTextRunnable);
        return true;
    }

    public boolean setSelection(final int start, final int end) {
        this.assertOnImeThread();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.setEditableSelectionOffsets(start, end);
            }
        });
        return true;
    }

    public boolean setComposingRegion(final int start, final int end) {
        this.assertOnImeThread();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.setComposingRegion(start, end);
            }
        });
        return true;
    }

    public CharSequence getTextBeforeCursor(int maxChars, int flags) {
        this.assertOnImeThread();
        TextInputState textInputState = this.requestAndWaitForTextInputState();
        if (textInputState == null) {
            return null;
        }
        return textInputState.getTextBeforeSelection(maxChars);
    }

    public CharSequence getTextAfterCursor(int maxChars, int flags) {
        this.assertOnImeThread();
        TextInputState textInputState = this.requestAndWaitForTextInputState();
        if (textInputState == null) {
            return null;
        }
        return textInputState.getTextAfterSelection(maxChars);
    }

    public CharSequence getSelectedText(int flags) {
        this.assertOnImeThread();
        TextInputState textInputState = this.requestAndWaitForTextInputState();
        if (textInputState == null) {
            return null;
        }
        return textInputState.getSelectedText();
    }

    public int getCursorCapsMode(int reqModes) {
        this.assertOnImeThread();
        return 0;
    }

    public boolean commitCompletion(CompletionInfo text) {
        this.assertOnImeThread();
        return false;
    }

    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        this.assertOnImeThread();
        return false;
    }

    public boolean clearMetaKeyStates(int states) {
        this.assertOnImeThread();
        return false;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        return false;
    }

    public boolean performPrivateCommand(String action, Bundle data) {
        this.assertOnImeThread();
        return false;
    }

    public boolean requestCursorUpdates(final int cursorUpdateMode) {
        this.assertOnImeThread();
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                ThreadedInputConnection.this.mImeAdapter.onRequestCursorUpdates(cursorUpdateMode);
            }
        });
        return true;
    }

    public void closeConnection() {
    }
}

