/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media.midi;

import android.annotation.TargetApi;
import android.media.midi.MidiDevice;
import android.media.midi.MidiDeviceInfo;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.midi.MidiInputPortAndroid;
import org.chromium.media.midi.MidiOutputPortAndroid;

@JNINamespace(value="media::midi")
@TargetApi(value=23)
class MidiDeviceAndroid {
    private final MidiDevice mDevice;
    private final MidiInputPortAndroid[] mInputPorts;
    private final MidiOutputPortAndroid[] mOutputPorts;
    private boolean mIsOpen = true;

    MidiDeviceAndroid(MidiDevice device) {
        int i;
        this.mDevice = device;
        this.mOutputPorts = new MidiOutputPortAndroid[this.getInfo().getInputPortCount()];
        for (i = 0; i < this.mOutputPorts.length; ++i) {
            this.mOutputPorts[i] = new MidiOutputPortAndroid(device, i);
        }
        this.mInputPorts = new MidiInputPortAndroid[this.getInfo().getOutputPortCount()];
        for (i = 0; i < this.mInputPorts.length; ++i) {
            this.mInputPorts[i] = new MidiInputPortAndroid(device, i);
        }
    }

    boolean isOpen() {
        return this.mIsOpen;
    }

    void close() {
        this.mIsOpen = false;
        for (MidiInputPortAndroid midiInputPortAndroid : this.mInputPorts) {
            midiInputPortAndroid.close();
        }
        for (MidiOutputPortAndroid midiOutputPortAndroid : this.mOutputPorts) {
            midiOutputPortAndroid.close();
        }
    }

    MidiDevice getDevice() {
        return this.mDevice;
    }

    MidiDeviceInfo getInfo() {
        return this.mDevice.getInfo();
    }

    @CalledByNative
    String getManufacturer() {
        return this.getProperty("manufacturer");
    }

    @CalledByNative
    String getProduct() {
        return this.getProperty("product");
    }

    @CalledByNative
    String getVersion() {
        return this.getProperty("version");
    }

    @CalledByNative
    MidiInputPortAndroid[] getInputPorts() {
        return this.mInputPorts;
    }

    @CalledByNative
    MidiOutputPortAndroid[] getOutputPorts() {
        return this.mOutputPorts;
    }

    private String getProperty(String name) {
        return this.mDevice.getInfo().getProperties().getString(name);
    }
}

