/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.nio.ByteBuffer;
import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.ConnectionErrorHandler;
import org.chromium.mojo.bindings.HandleOwner;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.system.AsyncWaiter;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.MojoException;
import org.chromium.mojo.system.ResultAnd;

public class Connector
implements MessageReceiver,
HandleOwner<MessagePipeHandle> {
    private final AsyncWaiterCallback mAsyncWaiterCallback = new AsyncWaiterCallback();
    private final MessagePipeHandle mMessagePipeHandle;
    private final AsyncWaiter mAsyncWaiter;
    private MessageReceiver mIncomingMessageReceiver;
    private AsyncWaiter.Cancellable mCancellable = null;
    private ConnectionErrorHandler mErrorHandler;

    public Connector(MessagePipeHandle messagePipeHandle) {
        this(messagePipeHandle, BindingsHelper.getDefaultAsyncWaiterForHandle(messagePipeHandle));
    }

    public Connector(MessagePipeHandle messagePipeHandle, AsyncWaiter asyncWaiter) {
        this.mMessagePipeHandle = messagePipeHandle;
        this.mAsyncWaiter = asyncWaiter;
    }

    public void setIncomingMessageReceiver(MessageReceiver incomingMessageReceiver) {
        this.mIncomingMessageReceiver = incomingMessageReceiver;
    }

    public void setErrorHandler(ConnectionErrorHandler errorHandler) {
        this.mErrorHandler = errorHandler;
    }

    public void start() {
        assert (this.mCancellable == null);
        this.registerAsyncWaiterForRead();
    }

    @Override
    public boolean accept(Message message) {
        try {
            this.mMessagePipeHandle.writeMessage(message.getData(), message.getHandles(), MessagePipeHandle.WriteFlags.NONE);
            return true;
        }
        catch (MojoException e) {
            this.onError(e);
            return false;
        }
    }

    @Override
    public MessagePipeHandle passHandle() {
        this.cancelIfActive();
        MessagePipeHandle handle = this.mMessagePipeHandle.pass();
        if (this.mIncomingMessageReceiver != null) {
            this.mIncomingMessageReceiver.close();
        }
        return handle;
    }

    @Override
    public void close() {
        this.cancelIfActive();
        this.mMessagePipeHandle.close();
        if (this.mIncomingMessageReceiver != null) {
            MessageReceiver incomingMessageReceiver = this.mIncomingMessageReceiver;
            this.mIncomingMessageReceiver = null;
            incomingMessageReceiver.close();
        }
    }

    private void onAsyncWaiterResult(int result) {
        this.mCancellable = null;
        if (result == 0) {
            this.readOutstandingMessages();
        } else {
            this.onError(new MojoException(result));
        }
    }

    private void onError(MojoException exception) {
        this.close();
        assert (this.mCancellable == null);
        if (this.mErrorHandler != null) {
            this.mErrorHandler.onConnectionError(exception);
        }
    }

    private void registerAsyncWaiterForRead() {
        assert (this.mCancellable == null);
        if (this.mAsyncWaiter != null) {
            this.mCancellable = this.mAsyncWaiter.asyncWait(this.mMessagePipeHandle, Core.HandleSignals.READABLE, -1L, this.mAsyncWaiterCallback);
        } else {
            this.onError(new MojoException(3));
        }
    }

    private void readOutstandingMessages() {
        ResultAnd<Boolean> result;
        do {
            try {
                result = Connector.readAndDispatchMessage(this.mMessagePipeHandle, this.mIncomingMessageReceiver);
            }
            catch (MojoException e) {
                this.onError(e);
                return;
            }
        } while (result.getValue().booleanValue());
        if (result.getMojoResult() == 17) {
            this.registerAsyncWaiterForRead();
        } else {
            this.onError(new MojoException(result.getMojoResult()));
        }
    }

    private void cancelIfActive() {
        if (this.mCancellable != null) {
            this.mCancellable.cancel();
            this.mCancellable = null;
        }
    }

    static ResultAnd<Boolean> readAndDispatchMessage(MessagePipeHandle handle, MessageReceiver receiver) {
        ResultAnd<MessagePipeHandle.ReadMessageResult> result = handle.readMessage(null, 0, MessagePipeHandle.ReadFlags.NONE);
        if (result.getMojoResult() != 8) {
            return new ResultAnd<Boolean>(result.getMojoResult(), false);
        }
        MessagePipeHandle.ReadMessageResult readResult = result.getValue();
        assert (readResult != null);
        ByteBuffer buffer = ByteBuffer.allocateDirect(readResult.getMessageSize());
        result = handle.readMessage(buffer, readResult.getHandlesCount(), MessagePipeHandle.ReadFlags.NONE);
        if (receiver != null && result.getMojoResult() == 0) {
            boolean accepted = receiver.accept(new Message(buffer, result.getValue().getHandles()));
            return new ResultAnd<Boolean>(result.getMojoResult(), accepted);
        }
        return new ResultAnd<Boolean>(result.getMojoResult(), false);
    }

    private class AsyncWaiterCallback
    implements AsyncWaiter.Callback {
        private AsyncWaiterCallback() {
        }

        @Override
        public void onResult(int result) {
            Connector.this.onAsyncWaiterResult(result);
        }

        @Override
        public void onError(MojoException exception) {
            Connector.this.mCancellable = null;
            Connector.this.onError(exception);
        }
    }
}

