/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.chromium.mojo.system.AsyncWaiter;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.MojoException;
import org.chromium.mojo.system.Pair;
import org.chromium.mojo.system.ResultAnd;

class ExecutorFactory {
    private static final ByteBuffer NOTIFY_BUFFER = null;
    private static final ThreadLocal<Executor> EXECUTORS = new ThreadLocal();

    ExecutorFactory() {
    }

    public static Executor getExecutorForCurrentThread(Core core) {
        Executor executor = EXECUTORS.get();
        if (executor == null) {
            executor = new PipedExecutor(core);
            EXECUTORS.set(executor);
        }
        return executor;
    }

    private static class PipedExecutor
    implements Executor,
    AsyncWaiter.Callback {
        private final MessagePipeHandle mWriteHandle;
        private final MessagePipeHandle mReadHandle;
        private final List<Runnable> mPendingActions;
        private final Object mLock;
        private final AsyncWaiter mWaiter;

        public PipedExecutor(Core core) {
            this.mWaiter = core.getDefaultAsyncWaiter();
            assert (this.mWaiter != null);
            this.mLock = new Object();
            Pair<MessagePipeHandle, MessagePipeHandle> handles = core.createMessagePipe(new MessagePipeHandle.CreateOptions());
            this.mReadHandle = (MessagePipeHandle)handles.first;
            this.mWriteHandle = (MessagePipeHandle)handles.second;
            this.mPendingActions = new ArrayList<Runnable>();
            this.asyncWait();
        }

        private void asyncWait() {
            this.mWaiter.asyncWait(this.mReadHandle, Core.HandleSignals.READABLE, -1L, this);
        }

        @Override
        public void onResult(int result) {
            if (result == 0 && this.readNotifyBufferMessage()) {
                this.runNextAction();
            } else {
                this.close();
            }
        }

        @Override
        public void onError(MojoException exception) {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            Object object = this.mLock;
            synchronized (object) {
                this.mWriteHandle.close();
                this.mPendingActions.clear();
            }
            this.mReadHandle.close();
        }

        private boolean readNotifyBufferMessage() {
            try {
                ResultAnd<MessagePipeHandle.ReadMessageResult> readMessageResult = this.mReadHandle.readMessage(NOTIFY_BUFFER, 0, MessagePipeHandle.ReadFlags.NONE);
                if (readMessageResult.getMojoResult() == 0) {
                    this.asyncWait();
                    return true;
                }
            }
            catch (MojoException mojoException) {
                // empty catch block
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runNextAction() {
            Runnable toRun = null;
            Object object = this.mLock;
            synchronized (object) {
                toRun = this.mPendingActions.remove(0);
            }
            toRun.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mWriteHandle.isValid()) {
                    throw new IllegalStateException("Trying to execute an action on a closed executor.");
                }
                this.mPendingActions.add(command);
                this.mWriteHandle.writeMessage(NOTIFY_BUFFER, null, MessagePipeHandle.WriteFlags.NONE);
            }
        }
    }
}

