/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojom.device;

import org.chromium.mojo.bindings.BindingsHelper;
import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.DeserializationException;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Interface;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.MessageReceiver;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.bindings.SideEffectFreeCloseable;
import org.chromium.mojo.bindings.Struct;
import org.chromium.mojo.system.Core;
import org.chromium.mojom.device.VibrationManager;

class VibrationManager_Internal {
    public static final Interface.Manager<VibrationManager, VibrationManager.Proxy> MANAGER = new Interface.Manager<VibrationManager, VibrationManager.Proxy>(){

        @Override
        public String getName() {
            return "device::VibrationManager";
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Proxy buildProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        public Stub buildStub(Core core, VibrationManager impl) {
            return new Stub(core, impl);
        }

        public VibrationManager[] buildArray(int size) {
            return new VibrationManager[size];
        }
    };
    private static final int VIBRATE_ORDINAL = 0;
    private static final int CANCEL_ORDINAL = 1;

    VibrationManager_Internal() {
    }

    static class VibrationManagerCancelResponseParamsProxyToResponder
    implements VibrationManager.CancelResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VibrationManagerCancelResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call() {
            VibrationManagerCancelResponseParams _response = new VibrationManagerCancelResponseParams();
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(1, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class VibrationManagerCancelResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final VibrationManager.CancelResponse mCallback;

        VibrationManagerCancelResponseParamsForwardToCallback(VibrationManager.CancelResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1, 2)) {
                    return false;
                }
                this.mCallback.call();
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class VibrationManagerCancelResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VibrationManagerCancelResponseParams(int version) {
            super(8, version);
        }

        public VibrationManagerCancelResponseParams() {
            this(0);
        }

        public static VibrationManagerCancelResponseParams deserialize(Message message) {
            return VibrationManagerCancelResponseParams.decode(new Decoder(message));
        }

        public static VibrationManagerCancelResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            VibrationManagerCancelResponseParams result = new VibrationManagerCancelResponseParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static final class VibrationManagerCancelParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VibrationManagerCancelParams(int version) {
            super(8, version);
        }

        public VibrationManagerCancelParams() {
            this(0);
        }

        public static VibrationManagerCancelParams deserialize(Message message) {
            return VibrationManagerCancelParams.decode(new Decoder(message));
        }

        public static VibrationManagerCancelParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            VibrationManagerCancelParams result = new VibrationManagerCancelParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static class VibrationManagerVibrateResponseParamsProxyToResponder
    implements VibrationManager.VibrateResponse {
        private final Core mCore;
        private final MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VibrationManagerVibrateResponseParamsProxyToResponder(Core core, MessageReceiver messageReceiver, long requestId) {
            this.mCore = core;
            this.mMessageReceiver = messageReceiver;
            this.mRequestId = requestId;
        }

        @Override
        public void call() {
            VibrationManagerVibrateResponseParams _response = new VibrationManagerVibrateResponseParams();
            ServiceMessage _message = _response.serializeWithHeader(this.mCore, new MessageHeader(0, 2, this.mRequestId));
            this.mMessageReceiver.accept(_message);
        }
    }

    static class VibrationManagerVibrateResponseParamsForwardToCallback
    extends SideEffectFreeCloseable
    implements MessageReceiver {
        private final VibrationManager.VibrateResponse mCallback;

        VibrationManagerVibrateResponseParamsForwardToCallback(VibrationManager.VibrateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0, 2)) {
                    return false;
                }
                this.mCallback.call();
                return true;
            }
            catch (DeserializationException e) {
                return false;
            }
        }
    }

    static final class VibrationManagerVibrateResponseParams
    extends Struct {
        private static final int STRUCT_SIZE = 8;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VibrationManagerVibrateResponseParams(int version) {
            super(8, version);
        }

        public VibrationManagerVibrateResponseParams() {
            this(0);
        }

        public static VibrationManagerVibrateResponseParams deserialize(Message message) {
            return VibrationManagerVibrateResponseParams.decode(new Decoder(message));
        }

        public static VibrationManagerVibrateResponseParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            VibrationManagerVibrateResponseParams result = new VibrationManagerVibrateResponseParams(mainDataHeader.elementsOrVersion);
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            return result;
        }
    }

    static final class VibrationManagerVibrateParams
    extends Struct {
        private static final int STRUCT_SIZE = 16;
        private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(16, 0)};
        private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long milliseconds;

        private VibrationManagerVibrateParams(int version) {
            super(16, version);
        }

        public VibrationManagerVibrateParams() {
            this(0);
        }

        public static VibrationManagerVibrateParams deserialize(Message message) {
            return VibrationManagerVibrateParams.decode(new Decoder(message));
        }

        public static VibrationManagerVibrateParams decode(Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            VibrationManagerVibrateParams result = new VibrationManagerVibrateParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.milliseconds = decoder0.readLong(8);
            }
            return result;
        }

        @Override
        protected final void encode(Encoder encoder) {
            Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(this.milliseconds, 8);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            VibrationManagerVibrateParams other = (VibrationManagerVibrateParams)object;
            return this.milliseconds == other.milliseconds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.getClass().hashCode();
            result = 31 * result + BindingsHelper.hashCode(this.milliseconds);
            return result;
        }
    }

    static final class Stub
    extends Interface.Stub<VibrationManager> {
        Stub(Core core, VibrationManager impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(Message message) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(0)) {
                    return false;
                }
                switch (header.getType()) {
                    case -2: {
                        return InterfaceControlMessagesHelper.handleRunOrClosePipe(MANAGER, messageWithHeader);
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(Message message, MessageReceiver receiver) {
            try {
                ServiceMessage messageWithHeader = message.asServiceMessage();
                MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(1)) {
                    return false;
                }
                switch (header.getType()) {
                    case -1: {
                        return InterfaceControlMessagesHelper.handleRun(this.getCore(), MANAGER, messageWithHeader, receiver);
                    }
                    case 0: {
                        VibrationManagerVibrateParams data = VibrationManagerVibrateParams.deserialize(messageWithHeader.getPayload());
                        ((VibrationManager)this.getImpl()).vibrate(data.milliseconds, new VibrationManagerVibrateResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case 1: {
                        VibrationManagerCancelParams.deserialize(messageWithHeader.getPayload());
                        ((VibrationManager)this.getImpl()).cancel(new VibrationManagerCancelResponseParamsProxyToResponder(this.getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                }
                return false;
            }
            catch (DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class Proxy
    extends Interface.AbstractProxy
    implements VibrationManager.Proxy {
        Proxy(Core core, MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void vibrate(long milliseconds, VibrationManager.VibrateResponse callback) {
            VibrationManagerVibrateParams _message = new VibrationManagerVibrateParams();
            _message.milliseconds = milliseconds;
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(0, 1, 0L)), new VibrationManagerVibrateResponseParamsForwardToCallback(callback));
        }

        @Override
        public void cancel(VibrationManager.CancelResponse callback) {
            VibrationManagerCancelParams _message = new VibrationManagerCancelParams();
            this.getProxyHandler().getMessageReceiver().acceptWithResponder(_message.serializeWithHeader(this.getProxyHandler().getCore(), new MessageHeader(1, 1, 0L)), new VibrationManagerCancelResponseParamsForwardToCallback(callback));
        }
    }
}

