/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.List;
import java.util.Set;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.ui.DropdownDividerDrawable;
import org.chromium.ui.DropdownItem;
import org.chromium.ui.R;

public class DropdownAdapter
extends ArrayAdapter<DropdownItem> {
    private final Context mContext;
    private final Set<Integer> mSeparators;
    private final boolean mAreAllItemsEnabled;

    public DropdownAdapter(Context context, List<? extends DropdownItem> items, Set<Integer> separators) {
        super(context, R.layout.dropdown_item);
        this.addAll(items);
        this.mSeparators = separators;
        this.mContext = context;
        this.mAreAllItemsEnabled = this.checkAreAllItemsEnabled();
    }

    private boolean checkAreAllItemsEnabled() {
        for (int i = 0; i < this.getCount(); ++i) {
            DropdownItem item = (DropdownItem)this.getItem(i);
            if (!item.isEnabled() || item.isGroupHeader()) continue;
            return false;
        }
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View layout2 = convertView;
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            layout2 = inflater.inflate(R.layout.dropdown_item, null);
            layout2.setBackground((Drawable)new DropdownDividerDrawable());
        }
        DropdownDividerDrawable divider = (DropdownDividerDrawable)layout2.getBackground();
        int height = this.mContext.getResources().getDimensionPixelSize(R.dimen.dropdown_item_height);
        if (position == 0) {
            divider.setColor(0);
        } else {
            int dividerHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.dropdown_item_divider_height);
            height += dividerHeight;
            divider.setHeight(dividerHeight);
            if (this.mSeparators != null && this.mSeparators.contains(position)) {
                divider.setColor(ApiCompatibilityUtils.getColor(this.mContext.getResources(), R.color.dropdown_dark_divider_color));
            } else {
                divider.setColor(ApiCompatibilityUtils.getColor(this.mContext.getResources(), R.color.dropdown_divider_color));
            }
        }
        DropdownItem item = (DropdownItem)this.getItem(position);
        View wrapper = layout2.findViewById(R.id.dropdown_label_wrapper);
        if (item.isMultilineLabel()) {
            height = -2;
        }
        wrapper.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, height, 1.0f));
        TextView labelView = (TextView)layout2.findViewById(R.id.dropdown_label);
        labelView.setText((CharSequence)item.getLabel());
        labelView.setSingleLine(!item.isMultilineLabel());
        labelView.setEnabled(item.isEnabled());
        if (item.isGroupHeader()) {
            labelView.setTypeface(null, 1);
        } else {
            labelView.setTypeface(null, 0);
        }
        TextView sublabelView = (TextView)layout2.findViewById(R.id.dropdown_sublabel);
        String sublabel = item.getSublabel();
        if (TextUtils.isEmpty((CharSequence)sublabel)) {
            sublabelView.setVisibility(8);
        } else {
            sublabelView.setText((CharSequence)sublabel);
            sublabelView.setVisibility(0);
        }
        ImageView iconView = (ImageView)layout2.findViewById(R.id.dropdown_icon);
        if (item.getIconId() == 0) {
            iconView.setVisibility(8);
        } else {
            iconView.setImageResource(item.getIconId());
            iconView.setVisibility(0);
        }
        return layout2;
    }

    public boolean areAllItemsEnabled() {
        return this.mAreAllItemsEnabled;
    }

    public boolean isEnabled(int position) {
        if (position < 0 || position >= this.getCount()) {
            return false;
        }
        DropdownItem item = (DropdownItem)this.getItem(position);
        return item.isEnabled() && !item.isGroupHeader();
    }
}

