/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkWebResourceResponseInternal;

class XWalkContentsClientCallbackHelper {
    private static final int MSG_ON_LOAD_RESOURCE = 1;
    private static final int MSG_ON_PAGE_STARTED = 2;
    private static final int MSG_ON_DOWNLOAD_START = 3;
    private static final int MSG_ON_RECEIVED_LOGIN_REQUEST = 4;
    private static final int MSG_ON_RECEIVED_ERROR = 5;
    private static final int MSG_ON_RESOURCE_LOAD_STARTED = 6;
    private static final int MSG_ON_PAGE_FINISHED = 7;
    private static final int MSG_ON_RECEIVED_RESPONSE_HEADERS = 8;
    private final XWalkContentsClient mContentsClient;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    String url = (String)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onLoadResource(url);
                    break;
                }
                case 2: {
                    String url = (String)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onPageStarted(url);
                    break;
                }
                case 3: {
                    DownloadInfo info = (DownloadInfo)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onDownloadStart(info.mUrl, info.mUserAgent, info.mContentDisposition, info.mMimeType, info.mContentLength);
                    break;
                }
                case 4: {
                    LoginRequestInfo info = (LoginRequestInfo)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onReceivedLoginRequest(info.mRealm, info.mAccount, info.mArgs);
                    break;
                }
                case 5: {
                    OnReceivedErrorInfo info = (OnReceivedErrorInfo)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onReceivedError(info.mErrorCode, info.mDescription, info.mFailingUrl);
                    break;
                }
                case 6: {
                    String url = (String)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onResourceLoadStarted(url);
                    break;
                }
                case 7: {
                    String url = (String)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onPageFinished(url);
                    break;
                }
                case 8: {
                    OnReceivedResponseHeadersInfo info = (OnReceivedResponseHeadersInfo)msg.obj;
                    XWalkContentsClientCallbackHelper.this.mContentsClient.onReceivedResponseHeaders(info.mRequest, info.mResponse);
                    break;
                }
                default: {
                    throw new IllegalStateException("XWalkContentsClientCallbackHelper: unhandled message " + msg.what);
                }
            }
        }
    };

    public XWalkContentsClientCallbackHelper(XWalkContentsClient contentsClient) {
        this.mContentsClient = contentsClient;
    }

    public void postOnLoadResource(String url) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)url));
    }

    public void postOnPageStarted(String url) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)url));
    }

    public void postOnDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
        DownloadInfo info = new DownloadInfo(url, userAgent, contentDisposition, mimeType, contentLength);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)info));
    }

    public void postOnReceivedLoginRequest(String realm, String account, String args) {
        LoginRequestInfo info = new LoginRequestInfo(realm, account, args);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)info));
    }

    public void postOnReceivedError(int errorCode, String description, String failingUrl) {
        OnReceivedErrorInfo info = new OnReceivedErrorInfo(errorCode, description, failingUrl);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, (Object)info));
    }

    public void postOnResourceLoadStarted(String url) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, (Object)url));
    }

    public void postOnPageFinished(String url) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, (Object)url));
    }

    public void postOnReceivedResponseHeaders(XWalkContentsClient.WebResourceRequestInner request, XWalkWebResourceResponseInternal response) {
        OnReceivedResponseHeadersInfo info = new OnReceivedResponseHeadersInfo(request, response);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)info));
    }

    private static class OnReceivedResponseHeadersInfo {
        final XWalkContentsClient.WebResourceRequestInner mRequest;
        final XWalkWebResourceResponseInternal mResponse;

        OnReceivedResponseHeadersInfo(XWalkContentsClient.WebResourceRequestInner request, XWalkWebResourceResponseInternal response) {
            this.mRequest = request;
            this.mResponse = response;
        }
    }

    private static class OnReceivedErrorInfo {
        final int mErrorCode;
        final String mDescription;
        final String mFailingUrl;

        OnReceivedErrorInfo(int errorCode, String description, String failingUrl) {
            this.mErrorCode = errorCode;
            this.mDescription = description;
            this.mFailingUrl = failingUrl;
        }
    }

    private static class LoginRequestInfo {
        final String mRealm;
        final String mAccount;
        final String mArgs;

        LoginRequestInfo(String realm, String account, String args) {
            this.mRealm = realm;
            this.mAccount = account;
            this.mArgs = args;
        }
    }

    private static class DownloadInfo {
        final String mUrl;
        final String mUserAgent;
        final String mContentDisposition;
        final String mMimeType;
        final long mContentLength;

        DownloadInfo(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
            this.mUrl = url;
            this.mUserAgent = userAgent;
            this.mContentDisposition = contentDisposition;
            this.mMimeType = mimeType;
            this.mContentLength = contentLength;
        }
    }
}

