/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.multi.qrcode.detector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.multi.qrcode.detector.MultiFinderPatternFinder$ModuleSizeComparator;
import oz.util.barcode.qrcode.detector.FinderPattern;
import oz.util.barcode.qrcode.detector.FinderPatternFinder;
import oz.util.barcode.qrcode.detector.FinderPatternInfo;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectMutipleBestPatterns() {
        List list = this.getPossibleCenters();
        int n = list.size();
        if (n < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n == 3) {
            return new FinderPattern[][]{{(FinderPattern)list.get(0), (FinderPattern)list.get(1), (FinderPattern)list.get(2)}};
        }
        Collections.sort(list, new MultiFinderPatternFinder$ModuleSizeComparator(null));
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        int n2 = 0;
        while (n2 < n - 2) {
            FinderPattern finderPattern = (FinderPattern)list.get(n2);
            if (finderPattern != null) {
                int n3 = n2 + 1;
                while (n3 < n - 1) {
                    FinderPattern finderPattern2 = (FinderPattern)list.get(n3);
                    if (finderPattern2 != null) {
                        float f2 = (finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                        float f3 = Math.abs(finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize());
                        if (f3 > 0.5f && f2 >= 0.05f) break;
                        int n4 = n3 + 1;
                        while (n4 < n) {
                            FinderPattern finderPattern3 = (FinderPattern)list.get(n4);
                            if (finderPattern3 != null) {
                                float f4;
                                float f5;
                                float f6;
                                float f7 = (finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), finderPattern3.getEstimatedModuleSize());
                                float f8 = Math.abs(finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize());
                                if (f8 > 0.5f && f7 >= 0.05f) break;
                                ResultPoint[] resultPointArray = new FinderPattern[]{finderPattern, finderPattern2, finderPattern3};
                                ResultPoint.orderBestPatterns(resultPointArray);
                                FinderPatternInfo finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
                                float f9 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getBottomLeft());
                                float f10 = ResultPoint.distance(finderPatternInfo.getTopRight(), finderPatternInfo.getBottomLeft());
                                float f11 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getTopRight());
                                float f12 = (f9 + f11) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                                if (!(f12 > 180.0f || f12 < 9.0f || (f6 = Math.abs((f9 - f11) / Math.min(f9, f11))) >= 0.1f || (f5 = Math.abs((f10 - (f4 = (float)Math.sqrt(f9 * f9 + f11 * f11))) / Math.min(f10, f4))) >= 0.1f)) {
                                    arrayList.add(resultPointArray);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            return (FinderPattern[][])arrayList.toArray((T[])new FinderPattern[arrayList.size()][]);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map map) {
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        BitMatrix bitMatrix = this.getImage();
        int n = bitMatrix.getHeight();
        int n2 = bitMatrix.getWidth();
        int n3 = (int)((float)n / 228.0f * 3.0f);
        if (n3 < 3 || bl) {
            n3 = 3;
        }
        int[] nArray = new int[5];
        int n4 = n3 - 1;
        while (n4 < n) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                if (bitMatrix.get(n6, n4)) {
                    if (n5 & true) {
                        // empty if block
                    }
                    int n7 = ++n5;
                    nArray[n7] = nArray[n7] + 1;
                } else if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(nArray) && this.handlePossibleCenter(nArray, n4, n6, false)) {
                            n5 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                        } else {
                            nArray[0] = nArray[2];
                            nArray[1] = nArray[3];
                            nArray[2] = nArray[4];
                            nArray[3] = 1;
                            nArray[4] = 0;
                            n5 = 3;
                        }
                    } else {
                        int n8 = ++n5;
                        nArray[n8] = nArray[n8] + 1;
                    }
                } else {
                    int n9 = n5;
                    nArray[n9] = nArray[n9] + 1;
                }
                ++n6;
            }
            if (MultiFinderPatternFinder.foundPatternCross(nArray)) {
                this.handlePossibleCenter(nArray, n4, n2, false);
            }
            n4 += n3;
        }
        FinderPattern[][] finderPatternArray = this.selectMutipleBestPatterns();
        ArrayList<FinderPatternInfo> arrayList = new ArrayList<FinderPatternInfo>();
        FinderPattern[][] finderPatternArray2 = finderPatternArray;
        int n10 = finderPatternArray.length;
        int n11 = 0;
        while (n11 < n10) {
            ResultPoint[] resultPointArray = finderPatternArray2[n11];
            ResultPoint.orderBestPatterns(resultPointArray);
            arrayList.add(new FinderPatternInfo((FinderPattern[])resultPointArray));
            ++n11;
        }
        if (arrayList.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        return arrayList.toArray(new FinderPatternInfo[arrayList.size()]);
    }
}

