package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import junit.framework.TestCase;

public class AbstractDaoTest extends TestCase {
	private static boolean created = false;

	@Override
	protected void setUp() throws Exception {
		if (!created) {
			DBConnector conn = DBConnector.getInstance();
			SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
			conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
			((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
			created = true;
		}
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	

	public void testDelete() throws Exception {
		AbstractDao dao = new AbstractDao();
		dao.beginTransaction();
		
		dao.delete("m_app_config", "app_config_name like ?", new String[]{"hoge%"});

//		dao.rollback();
		dao.commit();
	}

	public void testExecInsert() throws Exception {
		AbstractDao dao = new AbstractDao();
		dao.beginTransaction();
		
		long ret = dao.execInsert("insert into m_app_config values (?,?,?,?)", new String[]{"10","hogeaaa","000","111"});
//		System.out.println("insert: " + ret);
		ret = dao.execInsert("update m_app_config set val=? where app_config_id=?", new String[]{"1010","0"});
//		System.out.println("update: " + ret);

//		dao.rollback();
		dao.commit();
	}

	public void testExecSql() throws Exception {
		AbstractDao dao = new AbstractDao();
		dao.beginTransaction();

		dao.execSql("update m_app_config set val=55 where app_config_id=4");
		dao.execSql("update m_app_config set val=? where app_config_id=?", new String[]{"1220","2"});

//		dao.rollback();
		dao.commit();
	}

	public void testInsert() throws Exception {
		AbstractDao dao = new AbstractDao();
		dao.beginTransaction();

		dao.insert("insert into m_app_config values (?,?,?,?)", new String[]{"11","booaaa","1000","122"});

//		dao.rollback();
		dao.commit();
	}

	public void testUpdate() throws Exception {
		AbstractDao dao = new AbstractDao();
		dao.beginTransaction();

		long ret = dao.update("update m_app_config set val=? where app_config_id>=?", new String[]{"888","8"});
		System.out.println(ret);

//		dao.rollback();
		dao.commit();
	}

	public void testRawQueryGetInt() throws Exception {
		AbstractDao dao = new AbstractDao();
		System.out.println("count: " + dao.rawQueryGetInt("select count(*) from m_app_config where app_config_id>?", new String[]{"3"}));
	}

	public void testRawQueryGetString() throws Exception {
		AbstractDao dao = new AbstractDao();
		System.out.println("name: " + dao.rawQueryGetString("select app_config_name from m_app_config where app_config_id=?", new String[]{"3"}));
	}

//	public void testRawQueryGetDto() throws Exception {
//		AppConfigDao dao = new AppConfigDao();
//		System.out.println("dto: " + dao.rawQueryGetDto("select * from m_app_config where app_config_id=?", new String[]{"3"}, AppConfigDto.class));
//	}
//
//	public void testRawQueryGetDtoList() throws Exception {
//		AppConfigDao dao = new AppConfigDao();
//		List<AppConfigDto> list = dao.rawQueryGetDtoList("select * from m_app_config where app_config_id>?", new String[]{"3"}, AppConfigDto.class);
//		for (AppConfigDto appConfigDto : list) {
//			System.out.println("dto: " + appConfigDto);
//		}
//	}
	
	public void testVaccum() {
		AbstractDao dao = new AbstractDao();
		dao.vacuum();
	}

}
