package jp.agentec.abook.abv.launcher.android;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.Constant.ReportType;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterDto;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.DefPrefKey;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.UserPrefKey;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.OperationLocationType;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.StringUtil;

import android.content.Context;
import java.util.List;
import java.util.Stack;

public class ABVUIDataCache {
	private static final String TAG = "ABVUIDataCache";

	private Context context;
	
	// ホーム画面項目
	private int viewMode; // パンネル、リスト形式

	// 作業種別絞り込み用のスタック
	public Stack<OperationGroupMasterDto> operationGroupMasterStack;

	private ArrayList<Integer> mReportTypes;
	
	public long lastUpdateTime = -1;
	public String searchText;
	
	public boolean isFirstLaunching = true; // ログアウトした時もtrueに変える
	public boolean checkLocationServiceFlg = true; // アプリ起動一回につき一度位置情報アラートを表示する
	
	public boolean preIsCatalogEdition;

	// ユーザ情報コピー元コンテンツID
	public long srcContentId = -1;

	//コンテンツビューからコンテンツビューへ戻る時のコンテンツ情報リスト
	public List<long[]> returnContentIdList = new ArrayList<>();

	/**
	 * 最上部に表示されているActivityのクラス名、つまりユーザに見えているActivityのクラス名です。<br>
	 * Activityにfocusがあるかどうかをもとにアプリがバックグラウンドになったかを判断します。
	 */
	public String visibleActivityName = null;
	

    public ABVUIDataCache(Context context) {
    	this.context = context;
    	init();
    }

    // 初期状態
	private void init() {
		viewMode = loadViewMode();
		operationGroupMasterStack = new Stack<>();
	}

    public long saveLastUpdateTime() {
    	lastUpdateTime = DateTimeUtil.getCurrentDate().getTime();
    	PreferenceUtil.putUserPref(context, UserPrefKey.LAST_UPDATE_TIME, lastUpdateTime);
    	return lastUpdateTime;
    }

	public void clear() {
		Logger.i(TAG, "clear all data");
		init();
		
	}

	public boolean getPermissionAccessLocation() {
		return PreferenceUtil.getUserPref(context, DefPrefKey.PERMISSION_ACCESS_LOCATION, false);
	}

	public boolean isShowedPermissionAccessLocationAlert() {
		return PreferenceUtil.getUserPref(context, UserPrefKey.SHOWED_PERMISSION_ACCESS_LOCATION_ALERT, false);
	}

	public int getViewMode() {
    	return PreferenceUtil.getUserPref(context, UserPrefKey.VIEW_MODE, 0);
//		return viewMode;
	}

	public void setViewMode(int viewMode) {
		this.viewMode = viewMode;
		PreferenceUtil.putUserPref(context, UserPrefKey.VIEW_MODE, viewMode);
	}

	private int loadViewMode() {
		return PreferenceUtil.getUserPref(context, UserPrefKey.VIEW_MODE, AppDefType.ViewMode.PANEL);
	}

	/**
	 * xmlにファイル書き込みされた
	 * 通常・作業種別のモード切り替えの値を取得
	 * @return
	 */
	public int getOperationGroupMasterMode() {
		return PreferenceUtil.getUserPref(context, UserPrefKey.OPERATION_GROUP_MASERT_MODE, 0);
	}

	/**
	 * 通常・作業種別のモード切り替えの値をxmlにファイル書き込みする
	 * @param operationGroupMasterMode
	 */
	public void setOperationGroupMasterMode(int operationGroupMasterMode) {
		PreferenceUtil.putUserPref(context, UserPrefKey.OPERATION_GROUP_MASERT_MODE, operationGroupMasterMode);
	}

	/**
	 * xmlに書き込みされた作業種別IDを取得
	 * @return
	 */
	public int getOperationGroupMasterId() {
		return PreferenceUtil.getUserPref(context, UserPrefKey.OPERATION_GROUP_MASERT_ID, 0);
	}

	/**
	 * xmlに作業種別IDをファイル書き込みする
	 * @param operationGroupMasterId
	 */
	public void setOperationGroupMasterId(int operationGroupMasterId) {
		PreferenceUtil.putUserPref(context, UserPrefKey.OPERATION_GROUP_MASERT_ID, operationGroupMasterId);
	}

	/**
	 * 保持していた作業種別のデータをクリアする
	 */
	public void clearOperationGroupMaster() {
		setOperationGroupMasterMode(OperationLocationType.ALL);
		setOperationGroupMasterId(0);
		operationGroupMasterStack.clear();
	}

	/**
	 * コンテンツビューからコンテンツビューへ
	 * 戻る時のコンテンツIDとページのセット
	 * @param contentId
	 * @param page
	 */
	public void setReturnContentIdList(long contentId, int page) {
			long contentInfo[] =new long[]{contentId,page};
			returnContentIdList.add(contentInfo);
	}

	//戻る時用のコンテンツIDとページ情報をリストで返す
	public List<long[]> getReturnContentIdList() { return returnContentIdList; }

	/**
	 * 戻る用コンテンツIDリストをリセット
	 */
	public void resetReturnContentIdList() {
		if (returnContentIdList.size() != 0) {
			returnContentIdList.clear();
		}
	}

	public void setOperationReportTypes(ArrayList<Integer> operationReportTypes) {
		this.mReportTypes = operationReportTypes;
		String val = null;
		if (operationReportTypes.size() > 0) {
			// カンマ区切りで保存
			StringBuffer sb = new StringBuffer();
			for (int contentType : operationReportTypes) {
				sb.append(contentType);
				sb.append(",");
			}
			val = sb.substring(0, sb.length() - 1);
		}
		PreferenceUtil.putUserPref(context, UserPrefKey.OPERATION_REPORT_TYPES, val);
	}

	public ArrayList<Integer> getOperationReportTypes() {
		String operationReportTypesStr = PreferenceUtil.getUserPref(context, UserPrefKey.OPERATION_REPORT_TYPES, null);

		if (operationReportTypesStr != null) {
			ArrayList<Integer> operationReportTypes = new ArrayList<>();
			String[] operationReportTypesStrList = operationReportTypesStr.split(",");
			for (String contentType : operationReportTypesStrList) {
				if (!StringUtil.isNullOrEmpty(contentType)) {
					operationReportTypes.add(Integer.parseInt(contentType));
				}
			}
			mReportTypes = operationReportTypes;
		} else {
			mReportTypes = new ArrayList<Integer>();
			mReportTypes.add(ReportType.Report);
			mReportTypes.add(ReportType.RoutineTask);
			mReportTypes.add(ReportType.ReportReply);
		}

		return mReportTypes;
	}
}
