package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;

/**
 * Created by kim jinsung on 2018/09/18.
 */

public class PushMessageListAdapter extends BaseAdapter {
    private static final String TAG = "PushMessageListAdapter";
    private Context mContext;
    private LayoutInflater mInflater;
    private PushMessageListAdapter.PushMessageListAdapterListener listener;

    List<PushMessageDto> mListItem;

    public PushMessageListAdapter(Context context, List<PushMessageDto> objects) {
        mContext = context;
        mListItem = objects;
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public int getCount() {
        return mListItem.size();
    }

    @Override
    public PushMessageDto getItem(int position) {
        return mListItem.get(position);
    }

    public void setItem(List<PushMessageDto> objects) {
        mListItem= objects;
        notifyDataSetChanged();
    }

    @Override
    public long getItemId(int position) {
        return mListItem.get(position).pushMessageId;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_push_message_list, parent, false);
            holder = new PushMessageListAdapter.ViewHolder();
            holder.operationNameTextView = (TextView) convertView.findViewById(R.id.tv_operation_name);
            holder.sendDateTextView = (TextView) convertView.findViewById(R.id.tv_send_date);
            holder.messageTextView = (TextView) convertView.findViewById(R.id.tv_message);

            holder.detailButton = (Button) convertView.findViewById(R.id.btn_detail);
            convertView.setTag(holder);
        }else {
            holder = (ViewHolder) convertView.getTag();
        }

        final PushMessageDto pushMessageDto = getItem(position);

        settingDisplay(holder, pushMessageDto);

        return convertView;
    }

    private void settingDisplay(ViewHolder holder, final PushMessageDto pushMessageDto) {

        if (pushMessageDto != null) {
            holder.operationNameTextView.setText(pushMessageDto.operationName);
            holder.sendDateTextView.setText(DateTimeUtil.toString(pushMessageDto.pushSendDate, DateTimeFormat.yyyyMMddHHmm_slash));
            holder.messageTextView.setText(pushMessageDto.pushMessage);
            // リソースパターンの適用
            holder.detailButton.setText(PatternStringUtil.patternToString(mContext,
                                            R.string.detail,
                                            getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))	);

            if (pushMessageDto.readingFlg) {
                holder.detailButton.setBackgroundResource(R.drawable.btn_detail);
            } else {
                holder.detailButton.setBackgroundResource(R.drawable.btn_detail_with_badge);
            }

            holder.detailButton.findViewById(R.id.btn_detail).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    listener.onDetailView(pushMessageDto);
                }
            });
        }
    }

    private class ViewHolder {
        TextView operationNameTextView;
        TextView sendDateTextView;
        TextView messageTextView;
        Button detailButton;
    }

    public void setAdapterListener(PushMessageListAdapterListener listener) {
        this.listener = listener;
    }

    public interface PushMessageListAdapterListener {
        void onDetailView(PushMessageDto pushMessageDto);
    }
}
