package jp.agentec.abook.abv.ui.home.helper;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.abook.abv.ui.home.view.BreadCrumbButton;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;

/**
 * 階層構造をロジックの共通処理を実装
 * @author jang
 *
 */
public abstract class HierarchyOperationListHelper<StackObject> extends OperationListHelper implements OnClickListener {
	private final int MP = LayoutParams.MATCH_PARENT;
	private final int WP = LayoutParams.WRAP_CONTENT;
	protected Stack<StackObject> stack;

	private LinearLayout mHierarchyContentLayout = null;
	private LinearLayout mBreadCrumbsLayout = null;
	private ViewGroup mOperationListView = null;
	protected ArrayList<BreadCrumbButton> breadCrumbList = null;

	private HorizontalScrollView panList;
	/**
	 * 階層構造を持つ親クラス
	 * @param appActivity
	 */
	public HierarchyOperationListHelper(OperationListActivity appActivity) {
		super(appActivity);

		mHierarchyContentLayout = new LinearLayout(appActivity);
		mHierarchyContentLayout.setOrientation(LinearLayout.VERTICAL);

		View v = new View(appActivity);
		v.setBackgroundColor(Color.GRAY);
		LinearLayout.LayoutParams vlp = new LinearLayout.LayoutParams(MP, 1);
		mHierarchyContentLayout.addView(v, vlp);
		
		LinearLayout panListLayout = (LinearLayout) LayoutInflater.from(appActivity).inflate(R.layout.content_breadcrumb_layout, null);
		
		// 階層構造ビューを表示するボタン
		panListLayout.findViewById(R.id.btn_show_list_view).setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				mAppActivity.showOperationGroupMasterDialog(true,false);
			}
		});
		
		// パンくずのスクロールを作成
		panList = (HorizontalScrollView) panListLayout.findViewById(R.id.bread_crumbs_scroll_view);
		mBreadCrumbsLayout = (LinearLayout) panListLayout.findViewById(R.id.bread_crumbs_layout);
		breadCrumbList = new ArrayList<>();
		
		// パンくずリストを追加
		mHierarchyContentLayout.addView(panListLayout, new LinearLayout.LayoutParams(MP, WP));
	}

	public void addBreadCrumbs(String name) {
		addBreadCrumbs(name, stack.size() + 1);
	}

	public void addBreadCrumbs(String name, int level) {
		BreadCrumbButton bcb = new BreadCrumbButton(mAppActivity, name);
		bcb.level = level;
		breadCrumbList.add(bcb);
		bcb.setOnClickListener(this);
		LayoutParams l = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		mBreadCrumbsLayout.addView(bcb, l);
		// 右側へスクロールさせる
		panList.post(new Runnable() {
			@Override
			public void run() {
				panList.fullScroll(View.FOCUS_RIGHT);
			}
		});
	}

	protected void removeBreadCrumbs(View v) {
		mBreadCrumbsLayout.removeView(v);
		if (v instanceof BreadCrumbButton) {
			breadCrumbList.remove(v);
		}
	}

	/**
	 * 作業一覧のViewGroup取得
	 * @return
	 */
	@Override
	public ViewGroup getOperationView() {
		if (mOperationListView != null) {
			ViewGroup parent = (ViewGroup) mOperationListView.getParent();
			if (parent != null) {
				parent.removeView(mOperationListView);
			}
		}
		mOperationListView = super.getOperationView();
		LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(MP, 1);
		lp.weight = 1;
		mHierarchyContentLayout.addView(mOperationListView, 0, lp);
		return mHierarchyContentLayout;
	}

	/**
	 * HorizontalScrollViewパンくずボタンをクリック時に呼ばれるメソッド
	 */
	@Override
	public void onClick(View v) {
		BreadCrumbButton button = (BreadCrumbButton) v;
		
		int popCount = mBreadCrumbsLayout.getChildCount() - button.level;

		if (popCount > 0) {
			popList(popCount, true);
		}
	}

	/**
	 * 階層スタックの現在のサイズを返します
	 * 
	 * @return
	 */
	public int getStackSize() {
		return stack.size();
	}

	/**
	 * 指定した階層分上のリストへ移動する
	 * 
	 * @param popCount いくつ上の階層を表示するか指定します。
	 */
	abstract public void popList(int popCount, boolean isReload);

	/**
	 * 一つ下の階層のリストへ移動する
	 * 
	 * @param stackObject
	 */
	abstract public void pushList(StackObject stackObject);

	/**
	 * 子階層の一覧を取得します
	 * @return
	 */
	abstract public List<StackObject> getChildList();

	/**
	 * 現在の階層の名前を取得します
	 * @return
	 */
	abstract public String getPeekName();

	/**
	 * 一つ上の階層の名前を取得します
	 * @return
	 */
	abstract public String getPrePeekName();
}
