package jp.agentec.abook.abv.ui.home.helper;

import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;

/**
 * Created by leej on 2019/06/24.
 */

public class HomeOperationListHelper extends OperationListHelper {

    private static final String TAG = "HomeOperationListHelper";

    public HomeOperationListHelper(OperationListActivity activity) {
        super(activity);
    }

    @Override
    protected List<OperationDto> findOperationList() throws Exception {
        String reportTypeStr = getUserPref(mAppActivity, AppDefType.UserPrefKey.OPERATION_REPORT_TYPES, null);
        return operationLogic.getRefreshOperation(mAppActivity.mSearchWord, mAppActivity.mStartDateStr, mAppActivity.mEndDateStr, reportTypeStr);
    }
}
