/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import oz.lottie.LottieListener;
import oz.lottie.LottieResult;
import oz.lottie.LottieTask$1;
import oz.lottie.LottieTask$LottieFutureTask;
import oz.lottie.utils.Logger;

public class LottieTask {
    public static Executor EXECUTOR = Executors.newCachedThreadPool();
    private final Set successListeners = new LinkedHashSet(1);
    private final Set failureListeners = new LinkedHashSet(1);
    private final Handler handler = new Handler(Looper.getMainLooper());
    private volatile LottieResult result = null;

    public LottieTask(Callable callable) {
        this(callable, false);
    }

    LottieTask(Callable callable, boolean bl) {
        if (bl) {
            try {
                this.setResult((LottieResult)callable.call());
            }
            catch (Throwable throwable) {
                this.setResult(new LottieResult(throwable));
            }
        } else {
            EXECUTOR.execute(new LottieTask$LottieFutureTask(this, callable));
        }
    }

    private void setResult(LottieResult lottieResult) {
        if (this.result != null) {
            throw new IllegalStateException("A task may only be set once.");
        }
        this.result = lottieResult;
        this.notifyListeners();
    }

    public synchronized LottieTask addListener(LottieListener lottieListener) {
        if (this.result != null && this.result.getValue() != null) {
            lottieListener.onResult(this.result.getValue());
        }
        this.successListeners.add(lottieListener);
        return this;
    }

    public synchronized LottieTask removeListener(LottieListener lottieListener) {
        this.successListeners.remove(lottieListener);
        return this;
    }

    public synchronized LottieTask addFailureListener(LottieListener lottieListener) {
        if (this.result != null && this.result.getException() != null) {
            lottieListener.onResult(this.result.getException());
        }
        this.failureListeners.add(lottieListener);
        return this;
    }

    public synchronized LottieTask removeFailureListener(LottieListener lottieListener) {
        this.failureListeners.remove(lottieListener);
        return this;
    }

    private void notifyListeners() {
        this.handler.post((Runnable)new LottieTask$1(this));
    }

    private synchronized void notifySuccessListeners(Object object) {
        ArrayList arrayList = new ArrayList(this.successListeners);
        for (LottieListener lottieListener : arrayList) {
            lottieListener.onResult(object);
        }
    }

    private synchronized void notifyFailureListeners(Throwable throwable) {
        ArrayList arrayList = new ArrayList(this.failureListeners);
        if (arrayList.isEmpty()) {
            Logger.warning("Lottie encountered an error but no failure listener was added:", throwable);
            return;
        }
        for (LottieListener lottieListener : arrayList) {
            lottieListener.onResult(throwable);
        }
    }

    static /* synthetic */ void access$0(LottieTask lottieTask, LottieResult lottieResult) {
        lottieTask.setResult(lottieResult);
    }

    static /* synthetic */ LottieResult access$1(LottieTask lottieTask) {
        return lottieTask.result;
    }

    static /* synthetic */ void access$2(LottieTask lottieTask, Object object) {
        lottieTask.notifySuccessListeners(object);
    }

    static /* synthetic */ void access$3(LottieTask lottieTask, Throwable throwable) {
        lottieTask.notifyFailureListeners(throwable);
    }
}

