/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatablePointValue;
import oz.lottie.model.animatable.AnimatableValue;
import oz.lottie.model.content.RectangleShape;
import oz.lottie.parser.AnimatablePathValueParser;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;

class RectangleShapeParser {
    private static JsonReader$Options NAMES = JsonReader$Options.of("nm", "p", "s", "r", "hd");

    private RectangleShapeParser() {
    }

    static RectangleShape parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        String string = null;
        AnimatableValue animatableValue = null;
        AnimatablePointValue animatablePointValue = null;
        AnimatableFloatValue animatableFloatValue = null;
        boolean bl = false;
        while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    string = jsonReader.nextString();
                    break;
                }
                case 1: {
                    animatableValue = AnimatablePathValueParser.parseSplitPath(jsonReader, lottieComposition);
                    break;
                }
                case 2: {
                    animatablePointValue = AnimatableValueParser.parsePoint(jsonReader, lottieComposition);
                    break;
                }
                case 3: {
                    animatableFloatValue = AnimatableValueParser.parseFloat(jsonReader, lottieComposition);
                    break;
                }
                case 4: {
                    bl = jsonReader.nextBoolean();
                    break;
                }
                default: {
                    jsonReader.skipValue();
                }
            }
        }
        return new RectangleShape(string, animatableValue, animatablePointValue, animatableFloatValue, bl);
    }
}

