/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.utils;

public class GammaEvaluator {
    private static float OECF_sRGB(float f2) {
        return f2 <= 0.0031308f ? f2 * 12.92f : (float)(Math.pow(f2, 0.4166666567325592) * (double)1.055f - (double)0.055f);
    }

    private static float EOCF_sRGB(float f2) {
        return f2 <= 0.04045f ? f2 / 12.92f : (float)Math.pow((f2 + 0.055f) / 1.055f, 2.4f);
    }

    public static int evaluate(float f2, int n, int n2) {
        if (n == n2) {
            return n;
        }
        float f3 = (float)(n >> 24 & 0xFF) / 255.0f;
        float f4 = (float)(n >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(n & 0xFF) / 255.0f;
        float f7 = (float)(n2 >> 24 & 0xFF) / 255.0f;
        float f8 = (float)(n2 >> 16 & 0xFF) / 255.0f;
        float f9 = (float)(n2 >> 8 & 0xFF) / 255.0f;
        float f10 = (float)(n2 & 0xFF) / 255.0f;
        f4 = GammaEvaluator.EOCF_sRGB(f4);
        f5 = GammaEvaluator.EOCF_sRGB(f5);
        f6 = GammaEvaluator.EOCF_sRGB(f6);
        f8 = GammaEvaluator.EOCF_sRGB(f8);
        f9 = GammaEvaluator.EOCF_sRGB(f9);
        f10 = GammaEvaluator.EOCF_sRGB(f10);
        float f11 = f3 + f2 * (f7 - f3);
        float f12 = f4 + f2 * (f8 - f4);
        float f13 = f5 + f2 * (f9 - f5);
        float f14 = f6 + f2 * (f10 - f6);
        f12 = GammaEvaluator.OECF_sRGB(f12) * 255.0f;
        f13 = GammaEvaluator.OECF_sRGB(f13) * 255.0f;
        f14 = GammaEvaluator.OECF_sRGB(f14) * 255.0f;
        return Math.round(f11 *= 255.0f) << 24 | Math.round(f12) << 16 | Math.round(f13) << 8 | Math.round(f14);
    }
}

