/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview.format;

import android.text.SpannableStringBuilder;
import oz.materialcalendarview.CalendarDay;
import oz.materialcalendarview.format.TitleFormatter;

public class MonthArrayTitleFormatter
implements TitleFormatter {
    private final CharSequence[] monthLabels;

    public MonthArrayTitleFormatter(CharSequence[] charSequenceArray) {
        if (charSequenceArray == null) {
            throw new IllegalArgumentException("Label array cannot be null");
        }
        if (charSequenceArray.length < 12) {
            throw new IllegalArgumentException("Label array is too short");
        }
        this.monthLabels = charSequenceArray;
    }

    public CharSequence format(CalendarDay calendarDay) {
        return new SpannableStringBuilder().append(this.monthLabels[calendarDay.getMonth() - 1]).append((CharSequence)" ").append((CharSequence)String.valueOf(calendarDay.getYear()));
    }
}

