/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.util.regex.Pattern;
import oz.util.barcode.client.result.ParsedResult;
import oz.util.barcode.client.result.ParsedResultType;

public final class URIParsedResult
extends ParsedResult {
    private static final Pattern USER_IN_HOST = Pattern.compile(":/*([^/@]+)@[^/]+");
    private final String uri;
    private final String title;

    public URIParsedResult(String string, String string2) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(string);
        this.title = string2;
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return USER_IN_HOST.matcher(this.uri).find();
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(30);
        URIParsedResult.maybeAppend(this.title, stringBuilder);
        URIParsedResult.maybeAppend(this.uri, stringBuilder);
        return stringBuilder.toString();
    }

    private static String massageURI(String string) {
        int n = (string = string.trim()).indexOf(58);
        if (n < 0) {
            string = "http://" + string;
        } else if (URIParsedResult.isColonFollowedByPortNumber(string, n)) {
            string = "http://" + string;
        }
        return string;
    }

    private static boolean isColonFollowedByPortNumber(String string, int n) {
        int n2 = string.indexOf(47, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 <= n + 1) {
            return false;
        }
        int n3 = n + 1;
        while (n3 < n2) {
            if (string.charAt(n3) < '0' || string.charAt(n3) > '9') {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

